/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata.support;

import io.spring.initializr.generator.buildsystem.BuildItemResolver;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.metadata.BillOfMaterials;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.metadata.support.MetadataBuildItemMapper;

public final class MetadataBuildItemResolver
implements BuildItemResolver {
    private final InitializrMetadata metadata;
    private final Version platformVersion;

    public MetadataBuildItemResolver(InitializrMetadata metadata, Version platformVersion) {
        this.metadata = metadata;
        this.platformVersion = platformVersion;
    }

    public io.spring.initializr.generator.buildsystem.Dependency resolveDependency(String id) {
        Dependency dependency = this.metadata.getDependencies().get(id);
        if (dependency != null) {
            return MetadataBuildItemMapper.toDependency(dependency.resolve(this.platformVersion));
        }
        return null;
    }

    public io.spring.initializr.generator.buildsystem.BillOfMaterials resolveBom(String id) {
        BillOfMaterials bom = this.metadata.getConfiguration().getEnv().getBoms().get(id);
        if (bom != null) {
            return MetadataBuildItemMapper.toBom(bom.resolve(this.platformVersion));
        }
        return null;
    }

    public MavenRepository resolveRepository(String id) {
        if (id.equals(MavenRepository.MAVEN_CENTRAL.getId())) {
            return MavenRepository.MAVEN_CENTRAL;
        }
        return MetadataBuildItemMapper.toRepository(id, this.metadata.getConfiguration().getEnv().getRepositories().get(id));
    }
}

