/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.spring.initializr.metadata.DefaultMetadataElement;
import io.spring.initializr.metadata.Defaultable;
import io.spring.initializr.metadata.ServiceCapability;
import io.spring.initializr.metadata.ServiceCapabilityType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;

public class SingleSelectCapability
extends ServiceCapability<List<DefaultMetadataElement>>
implements Defaultable<DefaultMetadataElement> {
    private final List<DefaultMetadataElement> content = new ArrayList<DefaultMetadataElement>();
    private final ReadWriteLock contentLock = new ReentrantReadWriteLock();

    @JsonCreator
    SingleSelectCapability(@JsonProperty(value="id") String id) {
        this(id, null, null);
    }

    public SingleSelectCapability(String id, String title, String description) {
        super(id, ServiceCapabilityType.SINGLE_SELECT, title, description);
    }

    @Override
    public List<DefaultMetadataElement> getContent() {
        return Collections.unmodifiableList(this.withReadableContent(ArrayList::new));
    }

    public void addContent(DefaultMetadataElement element) {
        this.withWritableContent(content -> content.add(element));
    }

    public void setContent(List<DefaultMetadataElement> newContent) {
        this.withWritableContent(content -> {
            content.clear();
            content.addAll(newContent);
        });
    }

    @Override
    public DefaultMetadataElement getDefault() {
        return this.withReadableContent(content -> content.stream().filter(DefaultMetadataElement::isDefault).findFirst().orElse(null));
    }

    public DefaultMetadataElement get(String id) {
        return this.withReadableContent(content -> content.stream().filter(it -> id.equals(it.getId())).findFirst().orElse(null));
    }

    @Override
    public void merge(List<DefaultMetadataElement> otherContent) {
        this.withWritableContent(content -> otherContent.forEach(it -> {
            if (this.get(it.getId()) == null) {
                this.content.add((DefaultMetadataElement)it);
            }
        }));
    }

    private <T> T withReadableContent(Function<List<DefaultMetadataElement>, T> consumer) {
        this.contentLock.readLock().lock();
        try {
            T t = consumer.apply(this.content);
            return t;
        }
        finally {
            this.contentLock.readLock().unlock();
        }
    }

    private void withWritableContent(Consumer<List<DefaultMetadataElement>> consumer) {
        this.contentLock.writeLock().lock();
        try {
            consumer.accept(this.content);
        }
        finally {
            this.contentLock.writeLock().unlock();
        }
    }
}

