/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.spring.initializr.metadata.DefaultMetadataElement;
import io.spring.initializr.metadata.DependencyGroup;
import io.spring.initializr.metadata.InitializrConfiguration;
import io.spring.initializr.metadata.TextCapability;
import io.spring.initializr.metadata.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="initializr")
public class InitializrProperties
extends InitializrConfiguration {
    @JsonIgnore
    private final List<DependencyGroup> dependencies = new ArrayList<DependencyGroup>();
    @JsonIgnore
    private final List<Type> types = new ArrayList<Type>();
    @JsonIgnore
    private final List<DefaultMetadataElement> packagings = new ArrayList<DefaultMetadataElement>();
    @JsonIgnore
    private final List<DefaultMetadataElement> javaVersions = new ArrayList<DefaultMetadataElement>();
    @JsonIgnore
    private final List<DefaultMetadataElement> languages = new ArrayList<DefaultMetadataElement>();
    @JsonIgnore
    private final List<DefaultMetadataElement> bootVersions = new ArrayList<DefaultMetadataElement>();
    @JsonIgnore
    private final SimpleElement groupId = new SimpleElement("com.example");
    @JsonIgnore
    private final SimpleElement artifactId = new SimpleElement(null);
    @JsonIgnore
    private final SimpleElement version = new SimpleElement("0.0.1-SNAPSHOT");
    @JsonIgnore
    private final SimpleElement name = new SimpleElement("demo");
    @JsonIgnore
    private final SimpleElement description = new SimpleElement("Demo project for Spring Boot");
    @JsonIgnore
    private final SimpleElement packageName = new SimpleElement(null);

    public List<DependencyGroup> getDependencies() {
        return this.dependencies;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<DefaultMetadataElement> getPackagings() {
        return this.packagings;
    }

    public List<DefaultMetadataElement> getJavaVersions() {
        return this.javaVersions;
    }

    public List<DefaultMetadataElement> getLanguages() {
        return this.languages;
    }

    public List<DefaultMetadataElement> getBootVersions() {
        return this.bootVersions;
    }

    public SimpleElement getGroupId() {
        return this.groupId;
    }

    public SimpleElement getArtifactId() {
        return this.artifactId;
    }

    public SimpleElement getVersion() {
        return this.version;
    }

    public SimpleElement getName() {
        return this.name;
    }

    public SimpleElement getDescription() {
        return this.description;
    }

    public SimpleElement getPackageName() {
        return this.packageName;
    }

    public static final class SimpleElement {
        private String title;
        private String description;
        private String value;

        private SimpleElement(String value) {
            this.value = value;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void apply(TextCapability capability) {
            if (StringUtils.hasText((String)this.title)) {
                capability.setTitle(this.title);
            }
            if (StringUtils.hasText((String)this.description)) {
                capability.setDescription(this.description);
            }
            if (StringUtils.hasText((String)this.value)) {
                capability.setContent(this.value);
            }
        }
    }
}

