/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.kotlin;

import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.AnnotationContainer;
import io.spring.initializr.generator.language.ClassName;
import io.spring.initializr.generator.language.CodeBlock;
import io.spring.initializr.generator.language.kotlin.KotlinModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public final class KotlinPropertyDeclaration
implements Annotatable {
    private final AnnotationContainer annotations = new AnnotationContainer();
    private final boolean isVal;
    private final String name;
    private final String returnType;
    private final List<KotlinModifier> modifiers;
    private final CodeBlock valueCode;
    private final Accessor getter;
    private final Accessor setter;

    private KotlinPropertyDeclaration(Builder<?> builder) {
        this.name = builder.name;
        this.returnType = builder.returnType;
        this.modifiers = new ArrayList<KotlinModifier>(builder.modifiers);
        this.isVal = builder.isVal;
        this.valueCode = builder.valueCode;
        this.getter = builder.getter;
        this.setter = builder.setter;
    }

    public static ValBuilder val(String name) {
        return new ValBuilder(name);
    }

    public static VarBuilder var(String name) {
        return new VarBuilder(name);
    }

    boolean isVal() {
        return this.isVal;
    }

    String getName() {
        return this.name;
    }

    String getReturnType() {
        return this.returnType;
    }

    public List<KotlinModifier> getModifiers() {
        return this.modifiers;
    }

    CodeBlock getValueCode() {
        return this.valueCode;
    }

    Accessor getGetter() {
        return this.getter;
    }

    Accessor getSetter() {
        return this.setter;
    }

    @Override
    public AnnotationContainer annotations() {
        return this.annotations;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final boolean isVal;
        private final String name;
        private String returnType;
        private List<KotlinModifier> modifiers = new ArrayList<KotlinModifier>();
        private CodeBlock valueCode;
        private Accessor getter;
        private Accessor setter;

        private Builder(String name, boolean isVal) {
            this.name = name;
            this.isVal = isVal;
        }

        protected abstract T self();

        public AccessorBuilder<T> getter() {
            return new AccessorBuilder<Builder>(this, created -> {
                this.getter = created;
            });
        }

        public AccessorBuilder<T> setter() {
            return new AccessorBuilder<Builder>(this, created -> {
                this.setter = created;
            });
        }

        public T returning(String returnType) {
            this.returnType = returnType;
            return this.self();
        }

        public T modifiers(KotlinModifier ... modifiers) {
            this.modifiers = Arrays.asList(modifiers);
            return this.self();
        }

        public KotlinPropertyDeclaration emptyValue() {
            return new KotlinPropertyDeclaration(this);
        }

        public KotlinPropertyDeclaration value(CodeBlock valueCode) {
            this.valueCode = valueCode;
            return new KotlinPropertyDeclaration(this);
        }
    }

    static final class Accessor
    implements Annotatable {
        private final AnnotationContainer annotations;
        private final CodeBlock code;

        Accessor(AccessorBuilder<?> builder) {
            this.annotations = builder.annotations.deepCopy();
            this.code = builder.code;
        }

        CodeBlock getCode() {
            return this.code;
        }

        @Override
        public AnnotationContainer annotations() {
            return this.annotations;
        }
    }

    public static final class ValBuilder
    extends Builder<ValBuilder> {
        private ValBuilder(String name) {
            super(name, true);
        }

        @Override
        protected ValBuilder self() {
            return this;
        }
    }

    public static final class VarBuilder
    extends Builder<VarBuilder> {
        private VarBuilder(String name) {
            super(name, false);
        }

        public KotlinPropertyDeclaration empty() {
            return new KotlinPropertyDeclaration(this);
        }

        @Override
        protected VarBuilder self() {
            return this;
        }
    }

    public static final class AccessorBuilder<T extends Builder<T>> {
        private final AnnotationContainer annotations = new AnnotationContainer();
        private CodeBlock code;
        private final T parent;
        private final Consumer<Accessor> accessorFunction;

        private AccessorBuilder(T parent, Consumer<Accessor> accessorFunction) {
            this.parent = parent;
            this.accessorFunction = accessorFunction;
        }

        public AccessorBuilder<?> withAnnotation(ClassName className) {
            return this.withAnnotation(className, null);
        }

        public AccessorBuilder<?> withAnnotation(ClassName className, Consumer<Annotation.Builder> annotation) {
            this.annotations.add(className, annotation);
            return this;
        }

        public AccessorBuilder<?> withBody(CodeBlock code) {
            this.code = code;
            return this;
        }

        public T buildAccessor() {
            this.accessorFunction.accept(new Accessor(this));
            return this.parent;
        }
    }
}

