/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language;

import io.spring.initializr.generator.language.Language;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class SourceStructure {
    private final Path rootDirectory;
    private final String sourceFileExtension;
    private final Path sourcesDirectory;
    private final Path resourcesDirectory;

    public SourceStructure(Path rootDirectory, Language language) {
        this.rootDirectory = rootDirectory;
        this.sourceFileExtension = language.sourceFileExtension();
        this.sourcesDirectory = rootDirectory.resolve(language.id());
        this.resourcesDirectory = rootDirectory.resolve("resources");
    }

    public Path getRootDirectory() {
        return this.rootDirectory;
    }

    public Path getSourcesDirectory() {
        return this.sourcesDirectory;
    }

    public Path getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public Path resolveSourceFile(String packageName, String fileName) {
        String file = fileName + "." + this.sourceFileExtension;
        return SourceStructure.resolvePackage(this.sourcesDirectory, packageName).resolve(file);
    }

    public Path createSourceFile(String packageName, String fileName) throws IOException {
        Path sourceFile = this.resolveSourceFile(packageName, fileName);
        this.createFile(sourceFile);
        return sourceFile;
    }

    public Path resolveResourceFile(String packageName, String file) {
        return SourceStructure.resolvePackage(this.resourcesDirectory, packageName).resolve(file);
    }

    public Path createResourceFile(String packageName, String file) throws IOException {
        Path resourceFile = this.resolveResourceFile(packageName, file);
        this.createFile(resourceFile);
        return resourceFile;
    }

    private void createFile(Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.createFile(file, new FileAttribute[0]);
    }

    private static Path resolvePackage(Path directory, String packageName) {
        return directory.resolve(packageName.replace('.', '/'));
    }
}

