/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.maven.MavenResource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class MavenResourceContainer {
    private final Map<String, MavenResource.Builder> resources = new LinkedHashMap<String, MavenResource.Builder>();

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public boolean has(String directory) {
        return this.resources.containsKey(directory);
    }

    public Stream<MavenResource> values() {
        return this.resources.values().stream().map(MavenResource.Builder::build);
    }

    public void add(String directory) {
        this.resources.computeIfAbsent(directory, key -> new MavenResource.Builder(directory));
    }

    public void add(String directory, Consumer<MavenResource.Builder> resource) {
        resource.accept(this.resources.computeIfAbsent(directory, key -> new MavenResource.Builder(directory)));
    }

    public boolean remove(String directory) {
        return this.resources.remove(directory) != null;
    }
}

