/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.BillOfMaterials;
import io.spring.initializr.generator.buildsystem.Dependency;
import io.spring.initializr.generator.buildsystem.MavenRepository;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.buildsystem.gradle.GradleBuildWriter;
import io.spring.initializr.generator.buildsystem.gradle.GradleConfiguration;
import io.spring.initializr.generator.buildsystem.gradle.GradleConfigurationContainer;
import io.spring.initializr.generator.buildsystem.gradle.GradlePlugin;
import io.spring.initializr.generator.buildsystem.gradle.GradleTask;
import io.spring.initializr.generator.buildsystem.gradle.GradleTaskContainer;
import io.spring.initializr.generator.buildsystem.gradle.Invocation;
import io.spring.initializr.generator.buildsystem.gradle.StandardGradlePlugin;
import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.version.VersionProperty;
import io.spring.initializr.generator.version.VersionReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KotlinDslGradleBuildWriter
extends GradleBuildWriter {
    @Override
    protected void writeBuildscript(IndentingWriter writer, GradleBuild build) {
        if (!build.getBuildscript().getDependencies().isEmpty() || !build.getBuildscript().getExt().isEmpty()) {
            throw new IllegalStateException("build.gradle.kts scripts shouldn't need a buildscript");
        }
    }

    @Override
    protected void writePlugins(IndentingWriter writer, GradleBuild build) {
        this.writeNestedCollection(writer, "plugins", this.extractStandardPlugin(build), this::pluginAsString, null);
        writer.println();
        if (build.plugins().values().anyMatch(GradlePlugin::isApply)) {
            throw new IllegalStateException("build.gradle.kts scripts shouldn't apply plugins. They should use the plugins block instead.");
        }
    }

    private String pluginAsString(StandardGradlePlugin plugin) {
        Object result = this.shortPluginNotation(plugin.getId());
        if (result == null) {
            result = "id(\"" + plugin.getId() + "\")";
        }
        if (plugin.getVersion() != null) {
            result = (String)result + " version \"" + plugin.getVersion() + "\"";
        }
        return result;
    }

    private String shortPluginNotation(String pluginId) {
        if (pluginId.equals("java") || pluginId.equals("war") || pluginId.equals("groovy")) {
            return pluginId;
        }
        String kotlinPluginPrefix = "org.jetbrains.kotlin.";
        if (pluginId.startsWith(kotlinPluginPrefix)) {
            return "kotlin(\"" + pluginId.substring(kotlinPluginPrefix.length()) + "\")";
        }
        return null;
    }

    private String configurationReference(String configurationName, Collection<String> customConfigurations) {
        if (customConfigurations.contains(configurationName)) {
            return configurationName;
        }
        return "configurations." + configurationName + ".get()";
    }

    @Override
    protected String repositoryAsString(MavenRepository repository) {
        if (MavenRepository.MAVEN_CENTRAL.equals(repository)) {
            return "mavenCentral()";
        }
        return "maven { url = uri(\"" + repository.getUrl() + "\") }";
    }

    @Override
    protected void writeConfigurations(IndentingWriter writer, GradleConfigurationContainer configurations) {
        configurations.names().forEach(configuration -> writer.println("val " + configuration + " by configurations.creating"));
        if (configurations.customizations().findFirst().isEmpty()) {
            return;
        }
        writer.println("configurations {");
        List customConfigurations = configurations.names().collect(Collectors.toList());
        writer.indented(() -> configurations.customizations().forEach(configuration -> this.writeConfiguration(writer, (GradleConfiguration)configuration, customConfigurations)));
        writer.println("}");
        writer.println("");
    }

    protected void writeConfiguration(IndentingWriter writer, GradleConfiguration configuration, List<String> customConfigurations) {
        if (configuration.getExtendsFrom().isEmpty()) {
            writer.println(configuration.getName());
        } else {
            writer.println(configuration.getName() + " {");
            writer.indented(() -> writer.println(String.format("extendsFrom(%s)", configuration.getExtendsFrom().stream().map(name -> this.configurationReference((String)name, customConfigurations)).collect(Collectors.joining(", ")))));
            writer.println("}");
        }
    }

    @Override
    protected void writeDependency(IndentingWriter writer, Dependency dependency) {
        String version = this.determineVersion(dependency.getVersion());
        String classifier = dependency.getClassifier();
        String type = dependency.getType();
        writer.print(this.configurationForDependency(dependency) + "(\"" + dependency.getGroupId() + ":" + dependency.getArtifactId() + (String)(version != null ? ":" + version : "") + (String)(classifier != null ? ":" + classifier : "") + (String)(type != null ? "@" + type : "") + "\")");
        if (!dependency.getExclusions().isEmpty()) {
            writer.println(" {");
            writer.indented(() -> this.writeCollection(writer, dependency.getExclusions(), this::dependencyExclusionAsString));
            writer.println("}");
        } else {
            writer.println();
        }
    }

    private String dependencyExclusionAsString(Dependency.Exclusion exclusion) {
        return "exclude(group = \"" + exclusion.getGroupId() + "\", module = \"" + exclusion.getArtifactId() + "\")";
    }

    @Override
    protected void writeExtraProperties(IndentingWriter writer, Map<String, String> allProperties) {
        this.writeCollection(writer, allProperties.entrySet(), e -> this.getFormattedExtraProperty((String)e.getKey(), (String)e.getValue()), writer::println);
    }

    private String getFormattedExtraProperty(String key, String value) {
        return String.format("extra[\"%s\"] = %s", key, value);
    }

    @Override
    protected String bomAsString(BillOfMaterials bom) {
        return "mavenBom(\"" + bom.getGroupId() + ":" + bom.getArtifactId() + ":" + this.determineVersion(bom.getVersion()) + "\")";
    }

    private String determineVersion(VersionReference versionReference) {
        if (versionReference != null) {
            if (versionReference.isProperty()) {
                VersionProperty property = versionReference.getProperty();
                return "${property(\"" + (property.isInternal() ? property.toCamelCaseFormat() : property.toStandardFormat()) + "\")}";
            }
            return versionReference.getValue();
        }
        return null;
    }

    @Override
    protected void writeTasks(IndentingWriter writer, GradleTaskContainer tasks) {
        tasks.values().filter(candidate -> candidate.getType() != null).forEach(task -> {
            writer.println();
            writer.println("tasks.withType<" + task.getName() + "> {");
            writer.indented(() -> this.writeTaskCustomization(writer, (GradleTask)task));
            writer.println("}");
        });
        tasks.values().filter(candidate -> candidate.getType() == null).forEach(task -> {
            writer.println();
            writer.println("tasks." + task.getName() + " {");
            writer.indented(() -> this.writeTaskCustomization(writer, (GradleTask)task));
            writer.println("}");
        });
    }

    @Override
    protected String invocationAsString(Invocation invocation) {
        return invocation.getTarget() + "(" + String.join((CharSequence)", ", invocation.getArguments()) + ")";
    }

    @Override
    protected void writeProperty(IndentingWriter writer, String name, String value) {
        if (value != null) {
            writer.println(String.format("%s = \"%s\"", name, value));
        }
    }
}

