/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import io.spring.initializr.generator.buildsystem.gradle.GradleTask;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GradleTaskContainer {
    private final Map<String, GradleTask.Builder> tasks = new LinkedHashMap<String, GradleTask.Builder>();
    private final Set<String> importedTypes = new HashSet<String>();

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public boolean has(String name) {
        return this.tasks.containsKey(name);
    }

    public Stream<GradleTask> values() {
        return this.tasks.values().stream().map(GradleTask.Builder::build);
    }

    public GradleTask get(String task) {
        GradleTask.Builder builder = this.tasks.get(task);
        return builder != null ? builder.build() : null;
    }

    public Stream<String> importedTypes() {
        return this.importedTypes.stream();
    }

    public void customize(String name, Consumer<GradleTask.Builder> task) {
        task.accept(this.tasks.computeIfAbsent(name, GradleTask.Builder::new));
    }

    public void customizeWithType(String type, Consumer<GradleTask.Builder> task) {
        String packageName = ClassUtils.getPackageName((String)type);
        if (StringUtils.hasLength((String)packageName)) {
            this.importedTypes.add(type);
        }
        String shortName = ClassUtils.getShortName((String)type);
        task.accept(this.tasks.computeIfAbsent(shortName, name -> new GradleTask.Builder((String)name, type)));
    }

    public boolean remove(String name) {
        return this.tasks.remove(name) != null;
    }
}

