/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GradleBuildscript {
    private final List<String> dependencies;
    private final Map<String, String> ext;

    protected GradleBuildscript(Builder builder) {
        this.dependencies = Collections.unmodifiableList(new ArrayList<String>(builder.dependencies));
        this.ext = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.ext));
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public Map<String, String> getExt() {
        return this.ext;
    }

    public static class Builder {
        private final List<String> dependencies = new ArrayList<String>();
        private final Map<String, String> ext = new LinkedHashMap<String, String>();

        public Builder dependency(String coordinates) {
            this.dependencies.add(coordinates);
            return this;
        }

        public Builder ext(String name, String value) {
            this.ext.put(name, value);
            return this;
        }

        public GradleBuildscript build() {
            return new GradleBuildscript(this);
        }
    }
}

