/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.groovy;

import io.spring.initializr.generator.buildsystem.Build;
import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnPackaging;
import io.spring.initializr.generator.language.ClassName;
import io.spring.initializr.generator.language.CodeBlock;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.groovy.GroovyMethodDeclaration;
import io.spring.initializr.generator.language.groovy.GroovyTypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.MainApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.ServletInitializerCustomizer;
import io.spring.initializr.generator.spring.code.TestApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.groovy.GroovyDependenciesConfigurer;
import io.spring.initializr.generator.spring.code.groovy.GroovyMavenBuildCustomizer;
import io.spring.initializr.generator.version.VersionParser;
import io.spring.initializr.generator.version.VersionRange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class GroovyProjectGenerationDefaultContributorsConfiguration {
    private static final VersionRange GROOVY4 = VersionParser.DEFAULT.parseRange("3.0.0-M2");

    GroovyProjectGenerationDefaultContributorsConfiguration() {
    }

    @Bean
    MainApplicationTypeCustomizer<GroovyTypeDeclaration> mainMethodContributor() {
        return typeDeclaration -> typeDeclaration.addMethodDeclaration(GroovyMethodDeclaration.method((String)"main").modifiers(9).returning("void").parameters(new Parameter[]{Parameter.of((String)"args", String[].class)}).body(CodeBlock.ofStatement((String)"$T.run($L, args)", (Object[])new Object[]{"org.springframework.boot.SpringApplication", typeDeclaration.getName()})));
    }

    @Bean
    TestApplicationTypeCustomizer<GroovyTypeDeclaration> junitJupiterTestMethodContributor() {
        return typeDeclaration -> {
            GroovyMethodDeclaration method = GroovyMethodDeclaration.method((String)"contextLoads").returning("void").body(CodeBlock.of((String)"", (Object[])new Object[0]));
            method.annotations().add(ClassName.of((String)"org.junit.jupiter.api.Test"));
            typeDeclaration.addMethodDeclaration(method);
        };
    }

    @Bean
    BuildCustomizer<Build> groovyDependenciesConfigurer(ProjectDescription description) {
        return new GroovyDependenciesConfigurer(GROOVY4.match(description.getPlatformVersion()));
    }

    @Configuration
    @ConditionalOnBuildSystem(value="maven")
    static class GroovyMavenProjectConfiguration {
        GroovyMavenProjectConfiguration() {
        }

        @Bean
        GroovyMavenBuildCustomizer groovyBuildCustomizer() {
            return new GroovyMavenBuildCustomizer();
        }
    }

    @Configuration
    @ConditionalOnPackaging(value="war")
    static class WarPackagingConfiguration {
        WarPackagingConfiguration() {
        }

        @Bean
        ServletInitializerCustomizer<GroovyTypeDeclaration> javaServletInitializerCustomizer(ProjectDescription description) {
            return typeDeclaration -> {
                GroovyMethodDeclaration configure = GroovyMethodDeclaration.method((String)"configure").modifiers(4).returning("org.springframework.boot.builder.SpringApplicationBuilder").parameters(new Parameter[]{Parameter.of((String)"application", (String)"org.springframework.boot.builder.SpringApplicationBuilder")}).body(CodeBlock.ofStatement((String)"application.sources($L)", (Object[])new Object[]{description.getApplicationName()}));
                configure.annotations().add(ClassName.of(Override.class));
                typeDeclaration.addMethodDeclaration(configure);
            };
        }
    }
}

