/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UniAndCombination<I, O>
extends UniOperator<I, O> {
    private static final Object SENTINEL = new Object();
    private final Function<List<?>, O> combinator;
    private final List<Uni<?>> unis;
    private final boolean collectAllFailureBeforeFiring;
    private final int concurrency;

    public UniAndCombination(Uni<? extends I> upstream, List<? extends Uni<?>> others, Function<List<?>, O> combinator, boolean collectAllFailureBeforeFiring, int concurrency) {
        super(upstream);
        this.concurrency = concurrency;
        this.unis = new ArrayList();
        if (upstream != null) {
            this.unis.add(upstream);
        }
        this.unis.addAll(others);
        this.combinator = combinator;
        this.collectAllFailureBeforeFiring = collectAllFailureBeforeFiring;
    }

    @Override
    public void subscribe(UniSubscriber<? super O> subscriber) {
        AndSupervisor andSupervisor = new AndSupervisor(subscriber);
        subscriber.onSubscribe(andSupervisor);
        andSupervisor.run();
    }

    private class AndSupervisor
    implements UniSubscription {
        private final List<UniHandler> handlers = new ArrayList<UniHandler>();
        private final UniSubscriber<? super O> subscriber;
        final AtomicBoolean cancelled = new AtomicBoolean();
        final AtomicInteger nextIndex = new AtomicInteger();
        final AtomicInteger wip = new AtomicInteger();

        AndSupervisor(UniSubscriber<? super O> sub) {
            this.subscriber = sub;
            Context context = this.subscriber.context();
            for (Uni<?> uni : UniAndCombination.this.unis) {
                UniHandler result = new UniHandler(this, uni, context);
                this.handlers.add(result);
            }
        }

        private void run() {
            int upperBound;
            if (UniAndCombination.this.concurrency == -1) {
                upperBound = this.handlers.size();
            } else {
                upperBound = Math.min(this.handlers.size(), UniAndCombination.this.concurrency);
                this.nextIndex.set(upperBound);
            }
            for (int i = 0; i < upperBound && !this.cancelled.get(); ++i) {
                this.handlers.get(i).subscribe();
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.handlers.forEach(UniHandler::cancel);
            }
        }

        void check(UniHandler res, boolean failed) {
            int incomplete;
            if (this.wip.getAndIncrement() > 0) {
                return;
            }
            do {
                int nextIndex;
                incomplete = UniAndCombination.this.unis.size();
                if (failed && !UniAndCombination.this.collectAllFailureBeforeFiring) {
                    if (this.cancelled.compareAndSet(false, true)) {
                        this.handlers.forEach(UniHandler::cancel);
                        this.subscriber.onFailure(res.failure);
                    }
                    return;
                }
                for (UniHandler result : this.handlers) {
                    if (result.failure == null && result.item == SENTINEL) continue;
                    --incomplete;
                }
                if (incomplete == 0 && this.cancelled.compareAndSet(false, true)) {
                    List<Throwable> failures = this.getFailures();
                    List<Object> items = this.getItems();
                    this.computeAndFireTheOutcome(failures, items);
                }
                if (UniAndCombination.this.concurrency == -1 || this.cancelled.get() || (nextIndex = this.nextIndex.getAndIncrement()) >= UniAndCombination.this.unis.size()) continue;
                this.handlers.get(nextIndex).subscribe();
            } while (this.wip.decrementAndGet() > 0 && incomplete > 0);
        }

        private void computeAndFireTheOutcome(List<Throwable> failures, List<Object> items) {
            if (failures.isEmpty()) {
                Object aggregated;
                try {
                    aggregated = UniAndCombination.this.combinator.apply(items);
                }
                catch (Throwable e) {
                    this.subscriber.onFailure(e);
                    return;
                }
                this.subscriber.onItem(aggregated);
            } else if (failures.size() == 1) {
                this.subscriber.onFailure(failures.get(0));
            } else {
                this.subscriber.onFailure(new CompositeException(failures));
            }
        }

        private List<Object> getItems() {
            return this.handlers.stream().map(u -> u.item).collect(Collectors.toList());
        }

        private List<Throwable> getFailures() {
            return this.handlers.stream().filter(u -> u.failure != null).map(u -> u.failure).collect(Collectors.toList());
        }
    }

    private class UniHandler
    implements UniSubscription,
    UniSubscriber {
        final AndSupervisor supervisor;
        final Uni<?> uni;
        final Context context;
        volatile UniSubscription subscription;
        Object item = SENTINEL;
        Throwable failure;
        private static final AtomicReferenceFieldUpdater<UniHandler, UniSubscription> SUBSCRIPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UniHandler.class, UniSubscription.class, "subscription");

        UniHandler(AndSupervisor supervisor, Uni<?> observed, Context context) {
            this.supervisor = supervisor;
            this.uni = observed;
            this.context = context;
        }

        @Override
        public Context context() {
            return this.context;
        }

        @Override
        public final void onSubscribe(UniSubscription sub) {
            if (!SUBSCRIPTION_UPDATER.compareAndSet(this, null, sub)) {
                sub.cancel();
            }
        }

        @Override
        public final void onFailure(Throwable t) {
            if (SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED) == EmptyUniSubscription.CANCELLED) {
                Infrastructure.handleDroppedException(t);
                return;
            }
            this.failure = t;
            this.supervisor.check(this, true);
        }

        public final void onItem(Object x) {
            if (SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED) == EmptyUniSubscription.CANCELLED) {
                return;
            }
            this.item = x;
            this.supervisor.check(this, false);
        }

        @Override
        public void cancel() {
            Flow.Subscription sub = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
            if (sub != null) {
                sub.cancel();
            }
        }

        public void subscribe() {
            AbstractUni.subscribe(this.uni, this);
        }
    }
}

