/*
 * Decompiled with CFR 0.152.
 */
package io.shaka.http;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import com.sun.net.httpserver.spi.HttpServerProvider;
import io.shaka.http.HttpServer;
import io.shaka.http.HttpServerSslConfig;
import io.shaka.http.NoSslConfig$;
import io.shaka.http.PathAndPassword;
import io.shaka.http.Request;
import io.shaka.http.Response;
import io.shaka.http.SslConfig;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class HttpServer$ {
    public static final HttpServer$ MODULE$ = new HttpServer$();
    private static final Function1<String, BoxedUnit> printlnLog = (Function1 & Serializable)s -> {
        Predef$.MODULE$.println((Object)s);
        return BoxedUnit.UNIT;
    };

    public int $lessinit$greater$default$1() {
        return 0;
    }

    public HttpServerSslConfig $lessinit$greater$default$3() {
        return NoSslConfig$.MODULE$;
    }

    private Function1<String, BoxedUnit> printlnLog() {
        return printlnLog;
    }

    public HttpServer apply() {
        return this.apply(0);
    }

    public HttpServer apply(int port) {
        return new HttpServer(port, this.printlnLog(), this.$lessinit$greater$default$3());
    }

    public HttpServer apply(Function1<Request, Response> handler, int port, Function1<String, BoxedUnit> log) {
        return new HttpServer(port, log, this.$lessinit$greater$default$3()).handler(handler);
    }

    public int apply$default$2() {
        return 0;
    }

    public Function1<String, BoxedUnit> apply$default$3() {
        return this.printlnLog();
    }

    public HttpServer https(PathAndPassword keyStoreConfig, Option<PathAndPassword> maybeTrustStoreConfig, int port) {
        return new HttpServer(port, this.printlnLog(), new SslConfig(keyStoreConfig, maybeTrustStoreConfig));
    }

    public Option<PathAndPassword> https$default$2() {
        return None$.MODULE$;
    }

    public int https$default$3() {
        return 0;
    }

    public HttpServer httpsMutualAuth(PathAndPassword keyStoreConfig, PathAndPassword trustStoreConfig, int port) {
        return this.https(keyStoreConfig, (Option<PathAndPassword>)new Some((Object)trustStoreConfig), port);
    }

    public int httpsMutualAuth$default$3() {
        return 0;
    }

    public com.sun.net.httpserver.HttpServer io$shaka$http$HttpServer$$createServer(int requestedPort, HttpServerSslConfig sslConfig) {
        com.sun.net.httpserver.HttpServer httpServer;
        InetSocketAddress address = new InetSocketAddress(requestedPort);
        HttpServerProvider httpServerProvider = HttpServerProvider.provider();
        HttpServerSslConfig httpServerSslConfig = sslConfig;
        if (NoSslConfig$.MODULE$.equals(httpServerSslConfig)) {
            httpServer = httpServerProvider.createHttpServer(address, 0);
        } else if (httpServerSslConfig instanceof SslConfig) {
            SslConfig sslConfig2 = (SslConfig)httpServerSslConfig;
            PathAndPassword ksConfig = sslConfig2.keyStoreConfig();
            Option<PathAndPassword> maybeTsConfig = sslConfig2.trustStoreConfig();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(ksConfig.path()), ksConfig.password().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, ksConfig.password().toCharArray());
            TrustManager[] trustManagers = (TrustManager[])maybeTsConfig.fold((Function0 & Serializable)() -> null, (Function1 & Serializable)tsConfig -> {
                KeyStore ts = KeyStore.getInstance("JKS");
                ts.load(new FileInputStream(tsConfig.path()), tsConfig.password().toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ts);
                return tmf.getTrustManagers();
            });
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), trustManagers, new SecureRandom());
            HttpsServer server = httpServerProvider.createHttpsServer(address, 0);
            server.setHttpsConfigurator(new HttpsConfigurator(sslContext, maybeTsConfig){
                private final Option maybeTsConfig$1;

                public void configure(HttpsParameters httpsParameters) {
                    SSLParameters sslParameters = this.getSSLContext().getDefaultSSLParameters();
                    sslParameters.setNeedClientAuth(this.maybeTsConfig$1.isDefined());
                    httpsParameters.setSSLParameters(sslParameters);
                }
                {
                    this.maybeTsConfig$1 = maybeTsConfig$1;
                    super(sslContext$1);
                }
            });
            httpServer = server;
        } else {
            throw new MatchError((Object)httpServerSslConfig);
        }
        return httpServer;
    }

    private HttpServer$() {
    }
}

