/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.micrometer.observation;

import io.micrometer.observation.Observation;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.micrometer.tracing.internal.EncodingUtils;
import io.micrometer.tracing.propagation.Propagator;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.Payload;
import io.rsocket.metadata.TracingMetadataCodec;
import io.rsocket.micrometer.observation.PayloadUtils;
import io.rsocket.micrometer.observation.RSocketContext;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSocketRequesterTracingObservationHandler
implements TracingObservationHandler<RSocketContext> {
    private static final Logger log = LoggerFactory.getLogger(RSocketRequesterTracingObservationHandler.class);
    private final Propagator propagator;
    private final Propagator.Setter<CompositeByteBuf> setter;
    private final Tracer tracer;
    private final boolean isZipkinPropagationEnabled;

    public RSocketRequesterTracingObservationHandler(Tracer tracer, Propagator propagator, Propagator.Setter<CompositeByteBuf> setter, boolean isZipkinPropagationEnabled) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.setter = setter;
        this.isZipkinPropagationEnabled = isZipkinPropagationEnabled;
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof RSocketContext && ((RSocketContext)context).side == RSocketContext.Side.REQUESTER;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void onStart(RSocketContext context) {
        Payload payload = context.payload;
        Span.Builder spanBuilder = this.tracer.spanBuilder();
        Span parentSpan = this.getParentSpan((Observation.ContextView)context);
        if (parentSpan != null) {
            spanBuilder.setParent(parentSpan.context());
        }
        Span span = spanBuilder.kind(Span.Kind.PRODUCER).start();
        log.debug("Extracted result from context or thread local {}", (Object)span);
        CompositeByteBuf newMetadata = PayloadUtils.cleanTracingMetadata(payload, new HashSet<String>(this.propagator.fields()));
        TraceContext traceContext = span.context();
        if (this.isZipkinPropagationEnabled) {
            this.injectDefaultZipkinRSocketHeaders(newMetadata, traceContext);
        }
        this.propagator.inject(traceContext, (Object)newMetadata, this.setter);
        context.modifiedPayload = PayloadUtils.payload(payload, newMetadata);
        this.getTracingContext(context).setSpan(span);
    }

    public void onError(RSocketContext context) {
        Throwable error = context.getError();
        if (error != null) {
            this.getRequiredSpan(context).error(error);
        }
    }

    public void onStop(RSocketContext context) {
        Span span = this.getRequiredSpan(context);
        this.tagSpan(context, span);
        span.name(context.getContextualName()).end();
    }

    private void injectDefaultZipkinRSocketHeaders(CompositeByteBuf newMetadata, TraceContext traceContext) {
        boolean isTraceId128Bit;
        TracingMetadataCodec.Flags flags = traceContext.sampled() == null ? TracingMetadataCodec.Flags.UNDECIDED : (traceContext.sampled() != false ? TracingMetadataCodec.Flags.SAMPLE : TracingMetadataCodec.Flags.NOT_SAMPLE);
        String traceId = traceContext.traceId();
        long[] traceIds = EncodingUtils.fromString((CharSequence)traceId);
        long[] spanId = EncodingUtils.fromString((CharSequence)traceContext.spanId());
        long[] parentSpanId = EncodingUtils.fromString((CharSequence)traceContext.parentId());
        boolean bl = isTraceId128Bit = traceIds.length == 2;
        if (isTraceId128Bit) {
            TracingMetadataCodec.encode128((ByteBufAllocator)newMetadata.alloc(), (long)traceIds[0], (long)traceIds[1], (long)spanId[0], (long)EncodingUtils.fromString((CharSequence)traceContext.parentId())[0], (TracingMetadataCodec.Flags)flags);
        } else {
            TracingMetadataCodec.encode64((ByteBufAllocator)newMetadata.alloc(), (long)traceIds[0], (long)spanId[0], (long)parentSpanId[0], (TracingMetadataCodec.Flags)flags);
        }
    }
}

