/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.util.collection.IntObjectMap;

final class StreamIdSupplier {
    private static final int MASK = Integer.MAX_VALUE;
    private long streamId;

    StreamIdSupplier(int streamId) {
        this.streamId = streamId;
    }

    static StreamIdSupplier clientSupplier() {
        return new StreamIdSupplier(-1);
    }

    static StreamIdSupplier serverSupplier() {
        return new StreamIdSupplier(0);
    }

    int nextStreamId(IntObjectMap<?> streamIds) {
        int streamId;
        do {
            this.streamId += 2L;
        } while ((streamId = (int)(this.streamId & Integer.MAX_VALUE)) == 0 || streamIds.containsKey(streamId));
        return streamId;
    }

    boolean isBeforeOrCurrent(int streamId) {
        return this.streamId >= (long)streamId && streamId > 0;
    }
}

