/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import com.google.common.cache.Cache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AsciiString;
import java.util.concurrent.atomic.AtomicLong;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.server.StopEvent;
import ratpack.session.SessionStore;

public class LocalMemorySessionStore
implements SessionStore {
    private final Cache<AsciiString, ByteBuf> cache;
    private final AtomicLong lastCleanup = new AtomicLong(System.currentTimeMillis());

    public LocalMemorySessionStore(Cache<AsciiString, ByteBuf> cache) {
        this.cache = cache;
    }

    @Override
    public Operation store(AsciiString sessionId, ByteBuf sessionData) {
        return Operation.of(() -> {
            this.maybeCleanup();
            ByteBuf retained = Unpooled.unmodifiableBuffer((ByteBuf)sessionData);
            this.cache.put((Object)sessionId, (Object)retained);
        });
    }

    @Override
    public Promise<ByteBuf> load(AsciiString sessionId) {
        return Promise.ofLazy(() -> {
            this.maybeCleanup();
            ByteBuf value = (ByteBuf)this.cache.getIfPresent((Object)sessionId);
            if (value != null) {
                return Unpooled.unreleasableBuffer((ByteBuf)value.slice());
            }
            return Unpooled.buffer((int)0, (int)0);
        });
    }

    @Override
    public Promise<Long> size() {
        return Promise.ofLazy(() -> this.cache.size());
    }

    @Override
    public Operation remove(AsciiString sessionId) {
        return Operation.of(() -> {
            this.maybeCleanup();
            this.cache.invalidate((Object)sessionId);
        });
    }

    public void onStop(StopEvent event) throws Exception {
        this.cache.invalidateAll();
    }

    private void maybeCleanup() {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = this.lastCleanup.get()) > 10000L && this.lastCleanup.compareAndSet(last, now)) {
            this.cache.cleanUp();
        }
    }
}

