/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.store;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import javax.inject.Singleton;
import ratpack.handling.HandlerDecorator;
import ratpack.session.Session;
import ratpack.session.SessionManager;
import ratpack.session.store.SessionStorage;
import ratpack.session.store.SessionStore;
import ratpack.session.store.internal.DefaultSessionStore;

public class MapSessionsModule
extends AbstractModule {
    private final int maxEntries;
    private final int idleTimeoutMinutes;

    public MapSessionsModule(int maxEntries, int idleTimeoutMinutes) {
        this.maxEntries = maxEntries;
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), HandlerDecorator.class).addBinding().toInstance((Object)HandlerDecorator.prepend(ctx -> {
            ctx.getRequest().addLazy(SessionStorage.class, () -> {
                Session session = (Session)ctx.getRequest().get(Session.class);
                String id = session.getId();
                SessionStore sessionStore = (SessionStore)ctx.get(SessionStore.class);
                return sessionStore.get(id);
            });
            ctx.next();
        }));
    }

    @Provides
    @Singleton
    SessionStore provideMapSessionStore(SessionManager sessionManager) {
        DefaultSessionStore defaultMapSessionStore = new DefaultSessionStore(this.maxEntries, this.idleTimeoutMinutes);
        sessionManager.addSessionListener(defaultMapSessionStore);
        return defaultMapSessionStore;
    }
}

