/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.spi.Clob;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.h2.value.Value;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Schedulers;

class ValueLobClob
implements Clob {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private final Value lobDb;
    private SynchronousSink<CharSequence> valueLobHandlerSink;

    ValueLobClob(Value value) {
        this.lobDb = value;
    }

    public Flux<CharSequence> stream() {
        return Flux.generate(() -> new InputStreamReader(this.lobDb.getInputStream(), ENCODING), (source, sink) -> {
            this.valueLobHandlerSink = sink;
            try {
                char[] data = new char[256];
                int readBytes = source.read(data);
                if (readBytes == -1) {
                    sink.complete();
                    return source;
                }
                sink.next((Object)new String(data, 0, readBytes));
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
            return source;
        }, source -> {
            try {
                source.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).subscribeOn(Schedulers.boundedElastic()).cancelOn(Schedulers.boundedElastic());
    }

    public Mono<Void> discard() {
        return Mono.fromRunnable(() -> this.valueLobHandlerSink.complete()).then();
    }
}

