/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import java.time.Duration;
import org.h2.util.JSR310Utils;
import org.h2.value.Value;

final class DurationCodec
extends AbstractCodec<Duration> {
    DurationCodec() {
        super(Duration.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType != 28 && 24 <= dataType && dataType <= 34;
    }

    @Override
    Duration doDecode(Value value, Class<? extends Duration> type) {
        return JSR310Utils.valueToDuration((Value)value);
    }

    @Override
    Value doEncode(Duration value) {
        Assert.requireNonNull(value, "value must not be null");
        return JSR310Utils.durationToValue((Duration)value);
    }
}

