/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import org.h2.value.Value;
import org.h2.value.ValueTinyint;

final class ByteCodec
extends AbstractCodec<Byte> {
    ByteCodec() {
        super(Byte.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 9;
    }

    @Override
    Byte doDecode(Value value, Class<? extends Byte> type) {
        return value.getByte();
    }

    @Override
    Value doEncode(Byte value) {
        return ValueTinyint.get((byte)Assert.requireNonNull(value, "value must not be null"));
    }
}

