/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.client;

import io.r2dbc.h2.H2DatabaseExceptionFactory;
import io.r2dbc.h2.client.Binding;
import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.h2.command.CommandInterface;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Session;
import org.h2.engine.SessionRemote;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.value.Value;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class SessionClient
implements Client {
    private final Logger logger = Loggers.getLogger(this.getClass());
    private final Collection<Binding> emptyBinding = Collections.singleton(Binding.EMPTY);
    private final Session session;
    private final boolean shutdownDatabaseOnClose;

    public SessionClient(ConnectionInfo connectionInfo, boolean shutdownDatabaseOnClose) {
        Assert.requireNonNull(connectionInfo, "connectionInfo must not be null");
        this.session = new SessionRemote(connectionInfo).connectEmbeddedOrServer(false);
        this.shutdownDatabaseOnClose = shutdownDatabaseOnClose;
    }

    @Override
    public Mono<Void> close() {
        return Mono.defer(() -> {
            if (this.shutdownDatabaseOnClose) {
                try {
                    CommandInterface shutdown = this.session.prepareCommand("SHUTDOWN", 0);
                    shutdown.executeUpdate(null);
                }
                catch (DbException e) {
                    return Mono.error((Throwable)H2DatabaseExceptionFactory.convert(e));
                }
            }
            this.session.close();
            return Mono.empty();
        });
    }

    @Override
    public void disableAutoCommit() {
        this.session.setAutoCommit(false);
    }

    @Override
    public void enableAutoCommit() {
        this.session.setAutoCommit(true);
    }

    @Override
    public boolean inTransaction() {
        return !this.session.getAutoCommit();
    }

    @Override
    public Iterator<CommandInterface> prepareCommand(final String sql, List<Binding> bindings) {
        Binding binding;
        Assert.requireNonNull(sql, "sql must not be null");
        Assert.requireNonNull(bindings, "bindings must not be null");
        if (!bindings.isEmpty() && (binding = bindings.get(bindings.size() - 1)).getParameters().isEmpty()) {
            throw new IllegalStateException("You got an unbound binder!");
        }
        final Iterator<Binding> bindingIterator = bindings.isEmpty() ? this.emptyBinding.iterator() : bindings.iterator();
        return new Iterator<CommandInterface>(){
            final /* synthetic */ SessionClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return bindingIterator.hasNext();
            }

            @Override
            public CommandInterface next() {
                Binding binding = (Binding)bindingIterator.next();
                try {
                    CommandInterface command = this.this$0.createCommand(sql, binding);
                    this.this$0.logger.debug("Request:  {}", new Object[]{command});
                    return command;
                }
                catch (DbException e) {
                    throw H2DatabaseExceptionFactory.convert(e);
                }
            }
        };
    }

    @Override
    public ResultInterface query(CommandInterface command) {
        try {
            ResultInterface result = command.executeQuery(Integer.MAX_VALUE, false);
            this.logger.debug("Response: {}", new Object[]{result});
            return result;
        }
        catch (DbException e) {
            throw H2DatabaseExceptionFactory.convert(e);
        }
    }

    @Override
    public ResultWithGeneratedKeys update(CommandInterface command, Object generatedColumns) {
        return command.executeUpdate(generatedColumns);
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    private CommandInterface createCommand(String sql, Binding binding) {
        try {
            CommandInterface command = this.session.prepareCommand(sql, Integer.MAX_VALUE);
            ArrayList parameters = command.getParameters();
            for (Map.Entry<Integer, Value> entry : binding.getParameters().entrySet()) {
                ((ParameterInterface)parameters.get(entry.getKey())).setValue(entry.getValue(), false);
            }
            return command;
        }
        catch (DbException e) {
            throw H2DatabaseExceptionFactory.convert(e);
        }
    }
}

