/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.H2ColumnMetadata;
import io.r2dbc.h2.util.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.util.annotation.Nullable;

abstract class ColumnSource {
    private final List<H2ColumnMetadata> columns;
    private final Map<String, H2ColumnMetadata> nameKeyedColumns;

    ColumnSource(List<H2ColumnMetadata> columns) {
        this.columns = columns;
        this.nameKeyedColumns = ColumnSource.getNameKeyedColumns(columns);
    }

    private static Map<String, H2ColumnMetadata> getNameKeyedColumns(List<H2ColumnMetadata> columns) {
        if (columns.size() == 1) {
            return Collections.singletonMap(columns.get(0).getName(), columns.get(0));
        }
        LinkedHashMap<String, H2ColumnMetadata> byName = new LinkedHashMap<String, H2ColumnMetadata>(columns.size(), 1.0f);
        for (H2ColumnMetadata column : columns) {
            H2ColumnMetadata old = byName.put(column.getName(), column);
            if (old == null) continue;
            byName.put(column.getName(), old);
        }
        return byName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnSource)) {
            return false;
        }
        ColumnSource that = (ColumnSource)o;
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.nameKeyedColumns, that.nameKeyedColumns);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.nameKeyedColumns);
    }

    List<H2ColumnMetadata> getColumnMetadatas() {
        return this.columns;
    }

    int getColumnCount() {
        return this.columns.size();
    }

    H2ColumnMetadata getColumn(int index) {
        if (this.columns.size() > index && index >= 0) {
            return this.columns.get(index);
        }
        throw new IllegalArgumentException(String.format("Column index %d is larger than the number of columns %d", index, this.columns.size()));
    }

    H2ColumnMetadata getColumn(String name) {
        Assert.requireNonNull(name, "name must not be null");
        H2ColumnMetadata column = this.findColumn(name);
        if (column == null) {
            throw new IllegalArgumentException(String.format("Column name '%s' does not exist in column names %s", name.toUpperCase(), this.nameKeyedColumns.keySet()));
        }
        return column;
    }

    @Nullable
    H2ColumnMetadata findColumn(String name) {
        H2ColumnMetadata column = this.nameKeyedColumns.get(name);
        if (column == null && (name = ColumnSource.getColumnName(name, this.nameKeyedColumns.keySet())) != null) {
            column = this.nameKeyedColumns.get(name);
        }
        return column;
    }

    @Nullable
    private static String getColumnName(String name, Collection<String> names) {
        for (String s : names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }
}

