/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class EvalSectionHelper
implements SectionHelper {
    public static final String EVAL = "eval";
    private static final String TEMPLATE = "template";
    private final Map<String, Expression> parameters;
    private final Engine engine;

    public EvalSectionHelper(Map<String, Expression> parameters, Engine engine) {
        this.parameters = parameters;
        this.engine = engine;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        CompletableFuture<ResultNode> ret = new CompletableFuture<ResultNode>();
        if (this.parameters.size() > 1) {
            context.evaluate(this.parameters).whenComplete((evaluatedParams, t1) -> {
                if (t1 != null) {
                    ret.completeExceptionally((Throwable)t1);
                } else {
                    String contents = evaluatedParams.get(TEMPLATE).toString();
                    this.parseAndResolve(ret, contents, context.resolutionContext().createChild(Mapper.wrap(evaluatedParams), null));
                }
            });
        } else {
            Expression contents = this.parameters.get(TEMPLATE);
            if (contents.isLiteral()) {
                this.parseAndResolve(ret, contents.getLiteral().toString(), context.resolutionContext());
            } else {
                context.evaluate(contents).whenComplete((r, t) -> {
                    if (t != null) {
                        ret.completeExceptionally((Throwable)t);
                    } else {
                        this.parseAndResolve(ret, r.toString(), context.resolutionContext());
                    }
                });
            }
        }
        return ret;
    }

    private void parseAndResolve(CompletableFuture<ResultNode> ret, String contents, ResolutionContext resolutionContext) {
        try {
            Template template = this.engine.parse(contents);
            template.getRootNode().resolve(resolutionContext).whenComplete((resultNode, t2) -> {
                if (t2 != null) {
                    ret.completeExceptionally((Throwable)t2);
                } else {
                    ret.complete((ResultNode)resultNode);
                }
            });
        }
        catch (TemplateException e) {
            TemplateNode.Origin origin = this.parameters.get(TEMPLATE).getOrigin();
            ret.completeExceptionally(TemplateException.builder().message("Parser error in the evaluated template: {templateId} line {line}:\\n\\t{originalMessage}").code(Code.ERROR_IN_EVALUATED_TEMPLATE).argument("templateId", origin.hasNonGeneratedTemplateId() ? " template [" + origin.getTemplateId() + "]" : "").argument("line", origin.getLine()).argument("originalMessage", e.getMessage()).build());
        }
    }

    static enum Code implements ErrorCode
    {
        ERROR_IN_EVALUATED_TEMPLATE;


        @Override
        public String getName() {
            return "EVAL_" + this.name();
        }
    }

    public static class Factory
    implements SectionHelperFactory<EvalSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of(EvalSectionHelper.EVAL);
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(EvalSectionHelper.TEMPLATE).build();
        }

        @Override
        public EvalSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            HashMap<String, Expression> params = new HashMap<String, Expression>();
            for (Map.Entry<String, String> entry : context.getParameters().entrySet()) {
                params.put(entry.getKey(), context.getExpression(entry.getKey()));
            }
            return new EvalSectionHelper(params, context.getEngine());
        }

        @Override
        public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                for (Map.Entry<String, String> entry : block.getParameters().entrySet()) {
                    block.addExpression(entry.getKey(), entry.getValue());
                }
            }
            return outerScope;
        }
    }
}

