/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestResourceScope;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class TestResourceUtil {
    private TestResourceUtil() {
    }

    public static boolean testResourcesRequireReload(QuarkusTestExtensionState state, Class<?> nextTestClass, Class<? extends QuarkusTestProfile> nextTestClassProfile) {
        QuarkusTestProfile profileInstance = TestResourceUtil.instantiateProfile(nextTestClassProfile);
        Set<TestResourceManager.TestResourceComparisonInfo> existingTestResources = TestResourceUtil.existingTestResources(state);
        Set<TestResourceManager.TestResourceComparisonInfo> nextTestResources = TestResourceUtil.nextTestResources(nextTestClass, profileInstance);
        return TestResourceManager.testResourcesRequireReload(existingTestResources, nextTestResources);
    }

    static Set<TestResourceManager.TestResourceComparisonInfo> existingTestResources(QuarkusTestExtensionState state) {
        if (state == null) {
            return Collections.emptySet();
        }
        Closeable closeable = state.testResourceManager;
        if (closeable == null) {
            return Collections.emptySet();
        }
        if (TestResourceManager.class.getName().equals(closeable.getClass().getName())) {
            return TestResourceManagerReflections.testResourceComparisonInfo(closeable);
        }
        return Collections.emptySet();
    }

    static Set<TestResourceManager.TestResourceComparisonInfo> nextTestResources(Class<?> requiredTestClass, QuarkusTestProfile profileInstance) {
        List entriesFromProfile = Collections.emptyList();
        if (profileInstance != null) {
            entriesFromProfile = new ArrayList(profileInstance.testResources().size());
            for (QuarkusTestProfile.TestResourceEntry entry : profileInstance.testResources()) {
                entriesFromProfile.add(new TestResourceManager.TestResourceClassEntry(entry.getClazz(), entry.getArgs(), null, entry.isParallel(), TestResourceScope.MATCHING_RESOURCES));
            }
        }
        return TestResourceManager.testResourceComparisonInfo(requiredTestClass, (Path)PathTestHelper.getTestClassesLocation(requiredTestClass), entriesFromProfile);
    }

    public static String getReloadGroupIdentifier(Class<?> requiredTestClass, Class<? extends QuarkusTestProfile> profileClass) {
        return TestResourceManager.getReloadGroupIdentifier(TestResourceUtil.nextTestResources(requiredTestClass, TestResourceUtil.instantiateProfile(profileClass)));
    }

    private static QuarkusTestProfile instantiateProfile(Class<? extends QuarkusTestProfile> nextTestClassProfile) {
        if (nextTestClassProfile != null) {
            try {
                if (!QuarkusTestProfile.class.isAssignableFrom(nextTestClassProfile)) {
                    nextTestClassProfile = TestResourceUtil.class.getClassLoader().loadClass(nextTestClassProfile.getName());
                }
                return nextTestClassProfile.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static final class TestResourceManagerReflections {
        private TestResourceManagerReflections() {
        }

        public static <T> List<T> copyEntriesFromProfile(QuarkusTestProfile profileInstance, ClassLoader classLoader) {
            if (profileInstance == null || profileInstance.testResources().isEmpty()) {
                return Collections.emptyList();
            }
            try {
                Class<?> testResourceScopeClass = classLoader.loadClass(TestResourceScope.class.getName());
                Constructor<?> testResourceClassEntryConstructor = Class.forName(TestResourceManager.TestResourceClassEntry.class.getName(), true, classLoader).getConstructor(Class.class, Map.class, Annotation.class, Boolean.TYPE, testResourceScopeClass);
                List<QuarkusTestProfile.TestResourceEntry> testResources = profileInstance.testResources();
                ArrayList result = new ArrayList(testResources.size());
                for (QuarkusTestProfile.TestResourceEntry testResource : testResources) {
                    Object instance = testResourceClassEntryConstructor.newInstance(Class.forName(testResource.getClazz().getName(), true, classLoader), testResource.getArgs(), null, testResource.isParallel(), Enum.valueOf(testResourceScopeClass, TestResourceScope.MATCHING_RESOURCES.name()));
                    result.add(instance);
                }
                return result;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to handle profile " + String.valueOf(profileInstance.getClass()), e);
            }
        }

        public static Closeable createReflectively(Class<?> testResourceManagerClass, Class<?> testClass, Class<?> profileClass, List<TestResourceManager.TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources, Map<String, String> devServicesProperties, Optional<String> containerNetworkId, Path testClassLocation) {
            try {
                return (Closeable)testResourceManagerClass.getConstructor(Class.class, Class.class, List.class, Boolean.TYPE, Map.class, Optional.class, Path.class).newInstance(testClass, profileClass, additionalTestResources, disableGlobalTestResources, devServicesProperties, containerNetworkId, testClassLocation);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static Closeable createReflectively(Class<?> testResourceManagerClass, Class<?> testClass, Class<?> profileClass, List<TestResourceManager.TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources, Map<String, String> devServicesProperties, Optional<String> containerNetworkId) {
            try {
                return (Closeable)testResourceManagerClass.getConstructor(Class.class, Class.class, List.class, Boolean.TYPE, Map.class, Optional.class).newInstance(testClass, profileClass, additionalTestResources, disableGlobalTestResources, devServicesProperties, containerNetworkId);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static void initReflectively(Object testResourceManager, Class<?> profileClassName) {
            try {
                testResourceManager.getClass().getMethod("init", String.class).invoke(testResourceManager, profileClassName != null ? profileClassName.getName() : null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static Map<String, String> startReflectively(Object testResourceManager) {
            try {
                return (Map)testResourceManager.getClass().getMethod("start", new Class[0]).invoke(testResourceManager, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        static Set<TestResourceManager.TestResourceComparisonInfo> testResourceComparisonInfo(Object testResourceManager) {
            try {
                Set originalSet = (Set)testResourceManager.getClass().getMethod("testResourceComparisonInfo", new Class[0]).invoke(testResourceManager, new Object[0]);
                if (originalSet.isEmpty()) {
                    return Collections.emptySet();
                }
                HashSet<TestResourceManager.TestResourceComparisonInfo> result = new HashSet<TestResourceManager.TestResourceComparisonInfo>(originalSet.size());
                for (Object entry : originalSet) {
                    String testResourceLifecycleManagerClass = (String)entry.getClass().getMethod("testResourceLifecycleManagerClass", new Class[0]).invoke(entry, new Object[0]);
                    Object originalTestResourceScope = entry.getClass().getMethod("scope", new Class[0]).invoke(entry, new Object[0]);
                    TestResourceScope testResourceScope = null;
                    if (originalTestResourceScope != null) {
                        testResourceScope = TestResourceScope.valueOf((String)originalTestResourceScope.toString());
                    }
                    Object originalArgs = entry.getClass().getMethod("args", new Class[0]).invoke(entry, new Object[0]);
                    Map args = (Map)originalArgs;
                    result.add(new TestResourceManager.TestResourceComparisonInfo(testResourceLifecycleManagerClass, testResourceScope, args));
                }
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

