/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassBeanBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.deployment.builditem.TestProfileBuildItem;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.junit.DotNames;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.buildchain.TestBuildChainCustomizerProducer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Type;

public class TestBuildChainFunction
implements Function<Map<String, Object>, List<Consumer<BuildChainBuilder>>> {
    @Override
    public List<Consumer<BuildChainBuilder>> apply(final Map<String, Object> stringObjectMap) {
        final Path testLocation = (Path)stringObjectMap.get("test-location");
        final Index testClassesIndex = TestClassIndexer.readIndex((Path)testLocation, (Class)((Class)stringObjectMap.get("test-class")));
        ArrayList<Consumer<BuildChainBuilder>> allCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(1);
        Consumer<BuildChainBuilder> defaultCustomizer = new Consumer<BuildChainBuilder>(){

            @Override
            public void accept(BuildChainBuilder buildChainBuilder) {
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        context.produce((BuildItem)new TestClassPredicateBuildItem((Predicate)new Predicate<String>(){

                            @Override
                            public boolean test(String className) {
                                return PathTestHelper.isTestClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader(), (Path)testLocation);
                            }
                        }));
                    }
                }).produces(TestClassPredicateBuildItem.class).build();
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        context.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new Predicate<String>(){

                            @Override
                            public boolean test(String className) {
                                return QuarkusClassLoader.isApplicationClass((String)className);
                            }
                        }));
                    }
                }).produces(ApplicationClassPredicateBuildItem.class).build();
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        context.produce((BuildItem)new TestAnnotationBuildItem(QuarkusTest.class.getName()));
                    }
                }).produces(TestAnnotationBuildItem.class).build();
                final ArrayList<String> testClassBeans = new ArrayList<String>();
                List extendWith = testClassesIndex.getAnnotations(DotNames.EXTEND_WITH);
                for (AnnotationInstance annotationInstance : extendWith) {
                    Type[] extendsWithTypes;
                    ClassInfo classInfo;
                    if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS || (classInfo = annotationInstance.target().asClass()).isAnnotation()) continue;
                    for (Type type : extendsWithTypes = annotationInstance.value().asClassArray()) {
                        if (!DotNames.QUARKUS_TEST_EXTENSION.equals((Object)type.name())) continue;
                        testClassBeans.add(classInfo.name().toString());
                    }
                }
                List registerExtension = testClassesIndex.getAnnotations(DotNames.REGISTER_EXTENSION);
                for (AnnotationInstance annotationInstance : registerExtension) {
                    FieldInfo fieldInfo;
                    if (annotationInstance.target().kind() != AnnotationTarget.Kind.FIELD || !DotNames.QUARKUS_TEST_EXTENSION.equals((Object)(fieldInfo = annotationInstance.target().asField()).type().name())) continue;
                    testClassBeans.add(fieldInfo.declaringClass().name().toString());
                }
                if (!testClassBeans.isEmpty()) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            for (String quarkusExtendWithTestClass : testClassBeans) {
                                context.produce((BuildItem)new TestClassBeanBuildItem(quarkusExtendWithTestClass));
                            }
                        }
                    }).produces(TestClassBeanBuildItem.class).build();
                }
                buildChainBuilder.addBuildStep(new BuildStep(){

                    public void execute(BuildContext context) {
                        Object testProfile = stringObjectMap.get("test-profile");
                        if (testProfile != null) {
                            context.produce((BuildItem)new TestProfileBuildItem(testProfile.toString()));
                        }
                    }
                }).produces(TestProfileBuildItem.class).build();
            }
        };
        allCustomizers.add(defaultCustomizer);
        for (TestBuildChainCustomizerProducer testBuildChainCustomizerProducer : ServiceLoader.load(TestBuildChainCustomizerProducer.class, this.getClass().getClassLoader())) {
            allCustomizers.add(testBuildChainCustomizerProducer.produce(testClassesIndex));
        }
        return allCustomizers;
    }
}

