/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test;

import io.quarkus.test.PropertiesAsset;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

final class ExportUtil {
    static final String APPLICATION_PROPERTIES = "application.properties";

    private ExportUtil() {
    }

    static void exportToQuarkusDeploymentPath(JavaArchive archive) throws IOException {
        String exportPath = System.getProperty("quarkus.deploymentExportPath");
        if (exportPath == null) {
            return;
        }
        File exportDir = new File(exportPath);
        if (exportDir.exists()) {
            if (!exportDir.isDirectory()) {
                throw new IllegalStateException("Export path is not a directory: " + exportPath);
            }
            try (Stream<Path> stream = Files.walk(exportDir.toPath(), new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        } else if (!exportDir.mkdirs()) {
            throw new IllegalStateException("Export path could not be created: " + exportPath);
        }
        File exportFile = new File(exportDir, archive.getName());
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportFile);
    }

    static void mergeCustomApplicationProperties(JavaArchive archive, Properties customApplicationProperties) throws IOException {
        Node applicationProperties = archive.get(APPLICATION_PROPERTIES);
        if (applicationProperties != null) {
            Properties mergedProperties = new Properties();
            Asset asset = applicationProperties.getAsset();
            if (asset instanceof StringAsset) {
                StringAsset strAsset = (StringAsset)asset;
                mergedProperties.load(new StringReader(strAsset.getSource()));
            } else {
                try (InputStream in = asset.openStream();){
                    mergedProperties.load(in);
                }
            }
            customApplicationProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)mergedProperties::put));
            if (Boolean.parseBoolean(System.getProperty("quarkus.test.log-merged-properties"))) {
                System.out.println("Merged config properties:\n" + mergedProperties.keySet().stream().map(Object::toString).collect(Collectors.joining("\n")));
            } else {
                System.out.println("NOTE: overrideConfigKey() and application.properties were merged; use quarkus.test.log-merged-properties=true to list the specific values");
            }
            ExportUtil.deleteApplicationProperties(archive);
            archive.add((Asset)new PropertiesAsset(mergedProperties), APPLICATION_PROPERTIES);
        } else {
            archive.add((Asset)new PropertiesAsset(customApplicationProperties), APPLICATION_PROPERTIES);
        }
    }

    static void deleteApplicationProperties(JavaArchive archive) {
        archive.delete(APPLICATION_PROPERTIES);
    }
}

