/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.loader.json;

import io.quarkus.fs.util.ZipUtils;
import io.quarkus.platform.descriptor.loader.json.DirectoryResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ZipResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;

public final class ResourceLoaders {
    private static final String FILE = "file";
    private static final String JAR = "jar";

    private ResourceLoaders() {
    }

    public static File getResourceFile(URL url, String name) throws IOException {
        if (url == null) {
            throw new IOException("Failed to locate resource " + name + " on the classpath");
        }
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new IOException("There were a problem while reading the resource dir '" + name + "' on the classpath with url: '" + url.toString() + "'");
        }
    }

    public static ResourceLoader resolveFileResourceLoader(File f) {
        Objects.requireNonNull(f, "f is required");
        if (f.isDirectory()) {
            return new DirectoryResourceLoader(f.toPath());
        }
        if (f.isFile() && FilenameUtils.isExtension((String)f.getName(), (String[])new String[]{JAR, "zip"})) {
            return new ZipResourceLoader(f.toPath());
        }
        throw new IllegalStateException("No compatible ResourceLoader have been found for file type: " + f.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R processAsPath(URL url, Function<Path, R> function) {
        Path jar;
        if (!JAR.equals(url.getProtocol())) {
            if (!FILE.equals(url.getProtocol())) throw new IllegalArgumentException("Unexpected protocol " + url.getProtocol() + " for URL " + String.valueOf(url));
            return function.apply(ResourceLoaders.toLocalPath(url));
        }
        String file = url.getFile();
        int exclam = file.lastIndexOf(33);
        try {
            jar = ResourceLoaders.toLocalPath(exclam >= 0 ? new URL(file.substring(0, exclam)) : url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create a URL for '" + file.substring(0, exclam) + "'", e);
        }
        try (FileSystem jarFs = ZipUtils.newFileSystem((Path)jar);){
            Path localPath = jarFs.getPath("/", new String[0]);
            if (exclam >= 0) {
                localPath = localPath.resolve(file.substring(exclam + 1));
            }
            R r = function.apply(localPath);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + String.valueOf(jar), e);
        }
    }

    private static Path toLocalPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to translate " + String.valueOf(url) + " to local path", e);
        }
    }
}

