/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.registry.catalog.Extension;
import java.util.Objects;

public final class ExtensionUpdateInfo {
    private final TopExtensionDependency currentDep;
    private final Extension recommendedMetadata;
    private final TopExtensionDependency recommendedDep;
    private final VersionUpdateType versionUpdateType;

    public ExtensionUpdateInfo(TopExtensionDependency currentDep, Extension recommendedMetadata, TopExtensionDependency recommendedDep) {
        this.currentDep = currentDep;
        this.recommendedMetadata = recommendedMetadata;
        this.recommendedDep = recommendedDep;
        this.versionUpdateType = VersionUpdateType.computeVersionUpdateType(currentDep, recommendedDep);
    }

    public VersionUpdateType getVersionUpdateType() {
        return this.versionUpdateType;
    }

    public TopExtensionDependency getCurrentDep() {
        return this.currentDep;
    }

    public Extension getRecommendedMetadata() {
        return this.recommendedMetadata;
    }

    public TopExtensionDependency getRecommendedDependency() {
        return this.recommendedDep;
    }

    public boolean isUpdateRecommended() {
        return !Objects.equals(this.recommendedDep, this.currentDep);
    }

    public boolean shouldUpdateExtension() {
        return this.hasKeyChanged() || !VersionUpdateType.PLATFORM_MANAGED.equals((Object)this.versionUpdateType);
    }

    public boolean hasKeyChanged() {
        return !this.currentDep.getKey().equals((Object)this.recommendedDep.getKey());
    }

    public boolean isSimpleVersionUpdate() {
        return VersionUpdateType.UPDATE_VERSION.equals((Object)this.getVersionUpdateType()) || VersionUpdateType.RECOMMEND_PLATFORM_MANAGED.equals((Object)this.getVersionUpdateType());
    }

    public boolean isVersionUpdate() {
        return !VersionUpdateType.ADD_VERSION.equals((Object)this.getVersionUpdateType());
    }

    public static enum VersionUpdateType {
        PLATFORM_MANAGED,
        RECOMMEND_PLATFORM_MANAGED,
        ADD_VERSION,
        UPDATE_VERSION;


        static VersionUpdateType computeVersionUpdateType(TopExtensionDependency currentDep, TopExtensionDependency recommendedDep) {
            if (currentDep.isPlatformExtension() && recommendedDep.isPlatformExtension()) {
                if (currentDep.isNonRecommendedVersion()) {
                    return RECOMMEND_PLATFORM_MANAGED;
                }
                return PLATFORM_MANAGED;
            }
            if (currentDep.isPlatformExtension()) {
                return ADD_VERSION;
            }
            if (recommendedDep.isPlatformExtension()) {
                return RECOMMEND_PLATFORM_MANAGED;
            }
            return UPDATE_VERSION;
        }
    }
}

