/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.RequestReplyReceiverContext;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.netty.Metrics;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerObservations;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.observability.ReactorNettyHandlerContext;
import reactor.util.context.ContextView;

final class MicrometerHttpServerMetricsHandler
extends AbstractHttpServerMetricsHandler {
    final MicrometerHttpServerMetricsRecorder recorder;
    final String responseTimeName;
    ResponseTimeHandlerContext responseTimeHandlerContext;
    Observation responseTimeObservation;
    @Nullable ContextView parentContextView;

    MicrometerHttpServerMetricsHandler(MicrometerHttpServerMetricsRecorder recorder, @Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        super(methodTagValue, uriTagValue);
        this.recorder = recorder;
        this.responseTimeName = recorder.name() + ".response.time";
    }

    MicrometerHttpServerMetricsHandler(MicrometerHttpServerMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
        this.responseTimeName = copy.responseTimeName;
        this.responseTimeHandlerContext = copy.responseTimeHandlerContext;
        this.responseTimeObservation = copy.responseTimeObservation;
        this.parentContextView = copy.parentContextView;
    }

    @Override
    protected AbstractHttpServerMetricsHandler.MetricsArgProvider createMetricsArgProvider() {
        return super.createMetricsArgProvider().put(Observation.class, this.responseTimeObservation);
    }

    @Override
    protected HttpServerMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordWrite(Channel channel) {
        this.recordWrite(this.dataSent, this.dataSentTime, Objects.requireNonNull(this.method), Objects.requireNonNull(this.path), Objects.requireNonNull(this.remoteSocketAddress), this.responseTimeObservation, Objects.requireNonNull(this.status));
        ReactorNetty.setChannelContext((Channel)channel, (ContextView)this.parentContextView);
    }

    @Override
    protected void recordWrite(Channel channel, AbstractHttpServerMetricsHandler.MetricsArgProvider metricsArgProvider) {
        this.recordWrite(metricsArgProvider.dataSent, metricsArgProvider.dataSentTime, Objects.requireNonNull(metricsArgProvider.method), Objects.requireNonNull(metricsArgProvider.path), Objects.requireNonNull(metricsArgProvider.remoteSocketAddress), (Observation)Objects.requireNonNull(metricsArgProvider.get(Observation.class)), Objects.requireNonNull(metricsArgProvider.status));
    }

    void recordWrite(long dataSent, long dataSentTime, String method, String path, SocketAddress remoteSocketAddress, Observation responseTimeObservation, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - dataSentTime);
        this.recorder().recordDataSentTime(path, method, status, dataSentTimeDuration);
        this.recorder().recordDataSent(remoteSocketAddress, path, dataSent);
        responseTimeObservation.stop();
    }

    @Override
    protected void startRead(HttpServerOperations ops) {
        super.startRead(ops);
        this.responseTimeHandlerContext = new ResponseTimeHandlerContext(this.recorder, Objects.requireNonNull(this.method), Objects.requireNonNull(this.path), ops);
        this.responseTimeObservation = Observation.createNotStarted((String)this.responseTimeName, (Supplier)this.responseTimeHandlerContext, (ObservationRegistry)Metrics.OBSERVATION_REGISTRY);
        this.parentContextView = Metrics.updateChannelContext((Channel)ops.channel(), (Observation)this.responseTimeObservation);
        this.responseTimeObservation.start();
    }

    @Override
    protected void startWrite(HttpServerOperations ops) {
        super.startWrite(ops);
        if (this.responseTimeObservation == null) {
            this.responseTimeHandlerContext = new ResponseTimeHandlerContext(this.recorder, Objects.requireNonNull(this.method), Objects.requireNonNull(this.path), ops);
            this.responseTimeObservation = Observation.createNotStarted((String)this.responseTimeName, (Supplier)this.responseTimeHandlerContext, (ObservationRegistry)Metrics.OBSERVATION_REGISTRY);
            this.parentContextView = Metrics.updateChannelContext((Channel)ops.channel(), (Observation)this.responseTimeObservation);
            this.responseTimeObservation.start();
        }
        this.responseTimeHandlerContext.setResponse(ops.nettyResponse);
        this.responseTimeHandlerContext.status = Objects.requireNonNull(this.status);
    }

    @Override
    protected void reset(Channel channel) {
        super.reset(channel);
        if (this.isHttp11 && LAST_FLUSH_WHEN_NO_READ) {
            ReactorNetty.setChannelContext((Channel)channel, (ContextView)this.parentContextView);
        }
        this.responseTimeHandlerContext = null;
        this.responseTimeObservation = null;
        this.parentContextView = null;
    }

    static final class ResponseTimeHandlerContext
    extends RequestReplyReceiverContext<HttpRequest, HttpResponse>
    implements ReactorNettyHandlerContext,
    Supplier<Observation.Context> {
        static final String TYPE = "server";
        final String method;
        final String netHostName;
        final String netHostPort;
        final String path;
        final MicrometerHttpServerMetricsRecorder recorder;
        final String scheme;
        String status = "UNKNOWN";

        ResponseTimeHandlerContext(MicrometerHttpServerMetricsRecorder recorder, String method, String path, HttpServerOperations ops) {
            super((carrier, key) -> Objects.requireNonNull(carrier).headers().get(key));
            this.recorder = recorder;
            HttpRequest request = ops.nettyRequest;
            this.method = method;
            InetSocketAddress hostAddress = ops.hostAddress();
            this.netHostName = hostAddress != null ? hostAddress.getHostString() : "";
            this.netHostPort = hostAddress != null ? hostAddress.getPort() + "" : "";
            this.path = path;
            this.scheme = ops.scheme;
            this.setCarrier(request);
            this.setContextualName(this.method + '_' + this.path.substring(1));
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        public @Nullable Timer getTimer() {
            return this.recorder.getResponseTimeTimer(this.recorder.name() + ".response.time", this.path, this.method, this.status);
        }

        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{HttpServerObservations.ResponseTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE, HttpServerObservations.ResponseTimeHighCardinalityTags.HTTP_SCHEME.asString(), this.scheme, HttpServerObservations.ResponseTimeHighCardinalityTags.HTTP_STATUS_CODE.asString(), this.status, HttpServerObservations.ResponseTimeHighCardinalityTags.NET_HOST_NAME.asString(), this.netHostName, HttpServerObservations.ResponseTimeHighCardinalityTags.NET_HOST_PORT.asString(), this.netHostPort});
        }

        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{HttpServerObservations.ResponseTimeLowCardinalityTags.METHOD.asString(), this.method, HttpServerObservations.ResponseTimeLowCardinalityTags.STATUS.asString(), this.status, HttpServerObservations.ResponseTimeLowCardinalityTags.URI.asString(), this.path});
        }
    }
}

