/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import reactor.netty.http.logging.FullHttpRequestArgProvider;
import reactor.netty.http.logging.FullHttpResponseArgProvider;
import reactor.netty.http.logging.HttpContentArgProvider;
import reactor.netty.http.logging.HttpMessageArgProvider;
import reactor.netty.http.logging.HttpRequestArgProvider;
import reactor.netty.http.logging.HttpResponseArgProvider;
import reactor.netty.http.logging.LastHttpContentArgProvider;
import reactor.util.annotation.Nullable;

public final class HttpMessageArgProviderFactory {
    public static HttpMessageArgProvider create(Object httpObject) {
        return HttpMessageArgProviderFactory.create(httpObject, null);
    }

    public static HttpMessageArgProvider create(Object httpObject, @Nullable HttpVersion actualVersion) {
        if (httpObject instanceof FullHttpRequest) {
            return new FullHttpRequestArgProvider((FullHttpRequest)httpObject, actualVersion);
        }
        if (httpObject instanceof HttpRequest) {
            return new HttpRequestArgProvider((HttpRequest)httpObject, actualVersion);
        }
        if (httpObject instanceof FullHttpResponse) {
            return new FullHttpResponseArgProvider((FullHttpResponse)httpObject, actualVersion);
        }
        if (httpObject instanceof HttpResponse) {
            return new HttpResponseArgProvider((HttpResponse)httpObject, actualVersion);
        }
        if (httpObject instanceof LastHttpContent) {
            return new LastHttpContentArgProvider((LastHttpContent)httpObject);
        }
        if (httpObject instanceof HttpContent) {
            return new HttpContentArgProvider((HttpContent)httpObject);
        }
        throw new IllegalArgumentException("Unknown object: " + httpObject);
    }

    private HttpMessageArgProviderFactory() {
    }
}

