/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.bootstrap.ServerBootstrap;
import reactor.ipc.netty.options.ServerOptions;

public final class HttpServerOptions
extends ServerOptions {
    private final int minCompressionResponseSize;

    public static Builder builder() {
        return new Builder();
    }

    private HttpServerOptions(Builder builder) {
        super(builder);
        this.minCompressionResponseSize = builder.minCompressionResponseSize;
    }

    public int minCompressionResponseSize() {
        return this.minCompressionResponseSize;
    }

    @Override
    public HttpServerOptions duplicate() {
        return HttpServerOptions.builder().from(this).build();
    }

    @Override
    public String asSimpleString() {
        StringBuilder s = new StringBuilder(super.asSimpleString());
        if (this.minCompressionResponseSize >= 0) {
            s.append(", gzip");
            if (this.minCompressionResponseSize > 0) {
                s.append(" over ").append(this.minCompressionResponseSize).append(" bytes");
            }
        }
        return s.toString();
    }

    @Override
    public String asDetailedString() {
        return super.asDetailedString() + ", minCompressionResponseSize=" + this.minCompressionResponseSize;
    }

    @Override
    public String toString() {
        return "HttpServerOptions{" + this.asDetailedString() + "}";
    }

    public static final class Builder
    extends ServerOptions.Builder<Builder> {
        private int minCompressionResponseSize = -1;

        private Builder() {
            super(new ServerBootstrap());
        }

        public final Builder compression(boolean enabled) {
            this.minCompressionResponseSize = enabled ? 0 : -1;
            return (Builder)this.get();
        }

        public final Builder compression(int minResponseSize) {
            if (minResponseSize < 0) {
                throw new IllegalArgumentException("minResponseSize must be positive");
            }
            this.minCompressionResponseSize = minResponseSize;
            return (Builder)this.get();
        }

        @Override
        public final Builder from(HttpServerOptions options) {
            super.from(options);
            this.minCompressionResponseSize = options.minCompressionResponseSize;
            return (Builder)this.get();
        }

        @Override
        public HttpServerOptions build() {
            super.build();
            return new HttpServerOptions(this);
        }
    }
}

