/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.tokenParser;

import com.mitchellbosecke.pebble.error.ParserException;
import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.node.IncludeNode;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.node.expression.MapExpression;
import com.mitchellbosecke.pebble.parser.Parser;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;

public class IncludeTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        Expression<?> includeExpression = parser.getExpressionParser().parseExpression();
        Token current = stream.current();
        MapExpression mapExpression = null;
        if (current.getType().equals((Object)Token.Type.NAME) && current.getValue().equals("with")) {
            stream.next();
            Expression<?> parsedExpression = parser.getExpressionParser().parseExpression();
            if (parsedExpression instanceof MapExpression) {
                mapExpression = (MapExpression)parsedExpression;
            } else {
                throw new ParserException(null, String.format("Unexpected expression '%1s'.", parsedExpression.getClass().getCanonicalName()), token.getLineNumber(), stream.getFilename());
            }
        }
        stream.expect(Token.Type.EXECUTE_END);
        return new IncludeNode(lineNumber, includeExpression, mapExpression);
    }

    @Override
    public String getTag() {
        return "include";
    }
}

