/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.log;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.log.SpanLogsAppender;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import javax.annotation.PostConstruct;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnClass(value={Logger.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.log.enabled"}, havingValue="true", matchIfMissing=true)
public class LoggingAutoConfiguration {
    @Autowired
    private Tracer tracer;

    @PostConstruct
    public void postConstruct() {
        SpanLogsAppender spanLogsAppender = new SpanLogsAppender(this.tracer);
        spanLogsAppender.start();
        Logger rootLogger = this.getRootLogger();
        rootLogger.addAppender((Appender)spanLogsAppender);
    }

    private Logger getRootLogger() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        return context.getLogger("ROOT");
    }
}

