/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async.instrument;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ErrorHandler;
import org.springframework.util.concurrent.ListenableFuture;

public class TracedThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler {
    private final Tracer tracer;
    private final ThreadPoolTaskScheduler delegate;

    public TracedThreadPoolTaskScheduler(Tracer tracer, ThreadPoolTaskScheduler delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
    }

    public void setPoolSize(int poolSize) {
        this.delegate.setPoolSize(poolSize);
    }

    public void setRemoveOnCancelPolicy(boolean removeOnCancelPolicy) {
        this.delegate.setRemoveOnCancelPolicy(removeOnCancelPolicy);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.delegate.setErrorHandler(errorHandler);
    }

    public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
        return this.delegate.getScheduledExecutor();
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() throws IllegalStateException {
        return this.delegate.getScheduledThreadPoolExecutor();
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public boolean isRemoveOnCancelPolicy() {
        return this.delegate.isRemoveOnCancelPolicy();
    }

    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    public void execute(Runnable task) {
        this.delegate.execute((Runnable)new TracedRunnable(task, this.tracer));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute((Runnable)new TracedRunnable(task, this.tracer), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit((Runnable)new TracedRunnable(task, this.tracer));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit((Callable)new TracedCallable(task, this.tracer));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable((Runnable)new TracedRunnable(task, this.tracer));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable((Callable)new TracedCallable(task, this.tracer));
    }

    @Nullable
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.delegate.schedule((Runnable)new TracedRunnable(task, this.tracer), trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.delegate.schedule((Runnable)new TracedRunnable(task, this.tracer), startTime);
    }

    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        return this.delegate.schedule((Runnable)new TracedRunnable(task, this.tracer), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.delegate.scheduleAtFixedRate((Runnable)new TracedRunnable(task, this.tracer), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        return this.delegate.scheduleAtFixedRate((Runnable)new TracedRunnable(task, this.tracer), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.delegate.scheduleAtFixedRate((Runnable)new TracedRunnable(task, this.tracer), period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        return this.delegate.scheduleAtFixedRate((Runnable)new TracedRunnable(task, this.tracer), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)new TracedRunnable(task, this.tracer), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)new TracedRunnable(task, this.tracer), delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)new TracedRunnable(task, this.tracer), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        return this.delegate.scheduleWithFixedDelay((Runnable)new TracedRunnable(task, this.tracer), delay);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.delegate.setThreadFactory(threadFactory);
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.delegate.setThreadNamePrefix(threadNamePrefix);
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.delegate.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.delegate.setWaitForTasksToCompleteOnShutdown(waitForJobsToCompleteOnShutdown);
    }

    public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
        this.delegate.setAwaitTerminationSeconds(awaitTerminationSeconds);
    }

    public void setBeanName(String name) {
        this.delegate.setBeanName(name);
    }

    public void afterPropertiesSet() {
        this.delegate.afterPropertiesSet();
    }

    public void initialize() {
        this.delegate.initialize();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public Thread newThread(Runnable runnable) {
        return this.delegate.newThread(runnable);
    }

    public String getThreadNamePrefix() {
        return this.delegate.getThreadNamePrefix();
    }

    public void setThreadPriority(int threadPriority) {
        this.delegate.setThreadPriority(threadPriority);
    }

    public int getThreadPriority() {
        return this.delegate.getThreadPriority();
    }

    public void setDaemon(boolean daemon) {
        this.delegate.setDaemon(daemon);
    }

    public boolean isDaemon() {
        return this.delegate.isDaemon();
    }

    public void setThreadGroupName(String name) {
        this.delegate.setThreadGroupName(name);
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.delegate.setThreadGroup(threadGroup);
    }

    @Nullable
    public ThreadGroup getThreadGroup() {
        return this.delegate.getThreadGroup();
    }

    public Thread createThread(Runnable runnable) {
        return this.delegate.createThread(runnable);
    }

    public boolean prefersShortLivedTasks() {
        return this.delegate.prefersShortLivedTasks();
    }
}

