/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.LongCallable;
import io.opentelemetry.sdk.trace.export.SpanProcessorInstrumentation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class LegacySpanProcessorInstrumentation
implements SpanProcessorInstrumentation {
    private static final AttributeKey<String> SPAN_PROCESSOR_TYPE_LABEL = AttributeKey.stringKey((String)"processorType");
    private static final AttributeKey<Boolean> SPAN_PROCESSOR_DROPPED_LABEL = AttributeKey.booleanKey((String)"dropped");
    private static final String SPAN_PROCESSOR_TYPE_VALUE = BatchSpanProcessor.class.getSimpleName();
    private final Object lock = new Object();
    private final AtomicBoolean builtQueueMetrics = new AtomicBoolean(false);
    private final Supplier<MeterProvider> meterProvider;
    private final Attributes standardAttrs;
    private final Attributes droppedAttrs;
    @Nullable
    private Meter meter;
    @Nullable
    private volatile LongCounter processedSpans;

    LegacySpanProcessorInstrumentation(Supplier<MeterProvider> meterProvider) {
        this.meterProvider = meterProvider;
        this.standardAttrs = Attributes.of(SPAN_PROCESSOR_TYPE_LABEL, (Object)SPAN_PROCESSOR_TYPE_VALUE, SPAN_PROCESSOR_DROPPED_LABEL, (Object)false);
        this.droppedAttrs = Attributes.of(SPAN_PROCESSOR_TYPE_LABEL, (Object)SPAN_PROCESSOR_TYPE_VALUE, SPAN_PROCESSOR_DROPPED_LABEL, (Object)true);
    }

    @Override
    public void dropSpans(int count) {
        this.processedSpans().add((long)count, this.droppedAttrs);
    }

    @Override
    public void finishSpans(int count, @Nullable String error) {
        if (error != null) {
            this.processedSpans().add((long)count, this.standardAttrs);
        }
    }

    @Override
    public void buildQueueMetricsOnce(long unusedCapacity, LongCallable getSize) {
        if (!this.builtQueueMetrics.compareAndSet(false, true)) {
            return;
        }
        this.meter().gaugeBuilder("queueSize").ofLongs().setDescription("The number of items queued").setUnit("1").buildWithCallback(result -> result.record(getSize.get(), Attributes.of(SPAN_PROCESSOR_TYPE_LABEL, (Object)SPAN_PROCESSOR_TYPE_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongCounter processedSpans() {
        LongCounter processedSpans = this.processedSpans;
        if (processedSpans == null) {
            Object object = this.lock;
            synchronized (object) {
                processedSpans = this.processedSpans;
                if (processedSpans == null) {
                    this.processedSpans = processedSpans = this.meter().counterBuilder("processedSpans").setUnit("1").setDescription("The number of spans processed by the BatchSpanProcessor. [dropped=true if they were dropped due to high throughput]").build();
                }
            }
        }
        return processedSpans;
    }

    private Meter meter() {
        if (this.meter == null) {
            this.meter = this.meterProvider.get().get("io.opentelemetry.sdk.trace");
        }
        return this.meter;
    }
}

