/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.api.internal.IncubatingUtil;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

public final class GlobalOpenTelemetry {
    private static final String GLOBAL_AUTOCONFIGURE_ENABLED_PROPERTY = "otel.java.global-autoconfigure.enabled";
    private static final Logger logger = Logger.getLogger(GlobalOpenTelemetry.class.getName());
    private static final Object mutex = new Object();
    @Nullable
    private static volatile OpenTelemetry globalOpenTelemetry;
    @Nullable
    private static Throwable setGlobalCaller;

    private GlobalOpenTelemetry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTelemetry getOrNoop() {
        Object object = mutex;
        synchronized (object) {
            return globalOpenTelemetry != null ? globalOpenTelemetry : OpenTelemetry.noop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSet() {
        Object object = mutex;
        synchronized (object) {
            return globalOpenTelemetry != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTelemetry get() {
        OpenTelemetry openTelemetry = globalOpenTelemetry;
        if (openTelemetry == null) {
            Object object = mutex;
            synchronized (object) {
                openTelemetry = globalOpenTelemetry;
                if (openTelemetry == null) {
                    OpenTelemetry autoConfigured = GlobalOpenTelemetry.maybeAutoConfigureAndSetGlobal();
                    if (autoConfigured != null) {
                        return autoConfigured;
                    }
                    GlobalOpenTelemetry.set(OpenTelemetry.noop());
                    openTelemetry = Objects.requireNonNull(globalOpenTelemetry);
                }
            }
        }
        return openTelemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(OpenTelemetry openTelemetry) {
        Object object = mutex;
        synchronized (object) {
            if (globalOpenTelemetry != null) {
                throw new IllegalStateException("GlobalOpenTelemetry.set has already been called. GlobalOpenTelemetry.set must be called only once before any calls to GlobalOpenTelemetry.get. If you are using the OpenTelemetrySdk, use OpenTelemetrySdkBuilder.buildAndRegisterGlobal instead. Previous invocation set to cause of this exception.", setGlobalCaller);
            }
            globalOpenTelemetry = GlobalOpenTelemetry.obfuscatedOpenTelemetry(openTelemetry);
            setGlobalCaller = new Throwable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Supplier<OpenTelemetry> supplier) {
        Object object = mutex;
        synchronized (object) {
            OpenTelemetry openTelemetry = supplier.get();
            GlobalOpenTelemetry.set(openTelemetry);
        }
    }

    public static TracerProvider getTracerProvider() {
        return GlobalOpenTelemetry.get().getTracerProvider();
    }

    public static Tracer getTracer(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationScopeName);
    }

    public static Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationScopeName, instrumentationScopeVersion);
    }

    public static TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().tracerBuilder(instrumentationScopeName);
    }

    public static MeterProvider getMeterProvider() {
        return GlobalOpenTelemetry.get().getMeterProvider();
    }

    public static Meter getMeter(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().getMeter(instrumentationScopeName);
    }

    public static MeterBuilder meterBuilder(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().meterBuilder(instrumentationScopeName);
    }

    public static void resetForTest() {
        globalOpenTelemetry = null;
    }

    public static ContextPropagators getPropagators() {
        return GlobalOpenTelemetry.get().getPropagators();
    }

    @Nullable
    private static OpenTelemetry maybeAutoConfigureAndSetGlobal() {
        Class<?> openTelemetrySdkAutoConfiguration;
        try {
            openTelemetrySdkAutoConfiguration = Class.forName("io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        boolean globalAutoconfigureEnabled = Boolean.parseBoolean(ConfigUtil.getString(GLOBAL_AUTOCONFIGURE_ENABLED_PROPERTY, "false"));
        if (!globalAutoconfigureEnabled) {
            logger.log(Level.INFO, "AutoConfiguredOpenTelemetrySdk found on classpath but automatic configuration is disabled. To enable, run your JVM with -Dotel.java.global-autoconfigure.enabled=true");
            return null;
        }
        try {
            Method initialize = openTelemetrySdkAutoConfiguration.getMethod("initialize", new Class[0]);
            Object autoConfiguredSdk = initialize.invoke(null, new Object[0]);
            Method getOpenTelemetrySdk = openTelemetrySdkAutoConfiguration.getMethod("getOpenTelemetrySdk", new Class[0]);
            return GlobalOpenTelemetry.obfuscatedOpenTelemetry((OpenTelemetry)getOpenTelemetrySdk.invoke(autoConfiguredSdk, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("AutoConfiguredOpenTelemetrySdk detected on classpath but could not invoke initialize method. This is a bug in OpenTelemetry.", e);
        }
        catch (InvocationTargetException t) {
            logger.log(Level.SEVERE, "Error automatically configuring OpenTelemetry SDK. OpenTelemetry will not be enabled.", t.getTargetException());
            return null;
        }
    }

    private static OpenTelemetry obfuscatedOpenTelemetry(OpenTelemetry openTelemetry) {
        OpenTelemetry incubating = IncubatingUtil.obfuscatedOpenTelemetryIfIncubating(openTelemetry);
        if (incubating != null) {
            return incubating;
        }
        return new ObfuscatedOpenTelemetry(openTelemetry);
    }

    @ThreadSafe
    static class ObfuscatedOpenTelemetry
    implements OpenTelemetry {
        private final OpenTelemetry delegate;

        ObfuscatedOpenTelemetry(OpenTelemetry delegate) {
            this.delegate = delegate;
        }

        @Override
        public TracerProvider getTracerProvider() {
            return this.delegate.getTracerProvider();
        }

        @Override
        public MeterProvider getMeterProvider() {
            return this.delegate.getMeterProvider();
        }

        @Override
        public LoggerProvider getLogsBridge() {
            return this.delegate.getLogsBridge();
        }

        @Override
        public ContextPropagators getPropagators() {
            return this.delegate.getPropagators();
        }

        @Override
        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }
    }
}

