/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class InternalNetServerAttributesExtractor {
    private static final Logger logger = Logger.getLogger(InternalNetServerAttributesExtractor.class.getName());

    public static <REQUEST> void onStart(NetServerAttributesGetter<REQUEST> getter, AttributesBuilder attributes, REQUEST request, @Nullable String hostHeader) {
        String sockFamily;
        String sockHostAddr;
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_TRANSPORT, (Object)getter.transport(request));
        boolean setSockFamily = false;
        String sockPeerAddr = getter.sockPeerAddr(request);
        if (sockPeerAddr != null) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)sockPeerAddr);
            Integer sockPeerPort = getter.sockPeerPort(request);
            if (sockPeerPort != null && sockPeerPort > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_PORT, (Object)sockPeerPort);
            }
        }
        String hostName = getter.hostName(request);
        Integer hostPort = getter.hostPort(request);
        int hostHeaderSeparator = -1;
        if (hostHeader != null) {
            hostHeaderSeparator = hostHeader.indexOf(58);
        }
        if (hostName == null && hostHeader != null) {
            String string = hostName = hostHeaderSeparator == -1 ? hostHeader : hostHeader.substring(0, hostHeaderSeparator);
        }
        if (hostPort == null && hostHeader != null && hostHeaderSeparator != -1) {
            try {
                hostPort = Integer.parseInt(hostHeader.substring(hostHeaderSeparator + 1));
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (hostName != null) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_HOST_NAME, (Object)hostName);
            if (hostPort != null && hostPort > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_HOST_PORT, (Object)hostPort);
            }
        }
        if ((sockHostAddr = getter.sockHostAddr(request)) != null && !sockHostAddr.equals(hostName)) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_HOST_ADDR, (Object)sockHostAddr);
            Integer sockHostPort = getter.sockHostPort(request);
            if (sockHostPort != null && sockHostPort > 0 && !sockHostPort.equals(hostPort)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_HOST_PORT, (Object)sockHostPort);
            }
        }
        if (setSockFamily && (sockFamily = getter.sockFamily(request)) != null && !"inet".equals(sockFamily)) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_FAMILY, (Object)sockFamily);
        }
    }

    private InternalNetServerAttributesExtractor() {
    }
}

