/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.Signal;
import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.BlockingOperationException;
import io.netty.util.concurrent.DefaultPromiseListeners;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

public class DefaultPromise<V>
extends AbstractFuture<V>
implements Promise<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final int MAX_LISTENER_STACK_DEPTH = 8;
    private static final ThreadLocal<Integer> LISTENER_STACK_DEPTH = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final Signal SUCCESS = new Signal(DefaultPromise.class.getName() + ".SUCCESS");
    private final EventExecutor executor;
    private volatile Object result;
    private Object listeners;
    protected long state;

    public DefaultPromise(EventExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    protected DefaultPromise() {
        this.executor = null;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    @Override
    public boolean isSuccess() {
        Object result = this.result;
        if (result == null) {
            return false;
        }
        return !(result instanceof CauseHolder);
    }

    @Override
    public Throwable cause() {
        Object cause = this.result;
        if (cause instanceof CauseHolder) {
            return ((CauseHolder)cause).cause;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> addListener(GenericFutureListener<? extends Future<V>> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            DefaultPromise.notifyListener(this.executor(), this, listener);
            return this;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (!this.isDone()) {
                if (this.listeners == null) {
                    this.listeners = listener;
                } else if (this.listeners instanceof DefaultPromiseListeners) {
                    ((DefaultPromiseListeners)this.listeners).add(listener);
                } else {
                    this.listeners = new DefaultPromiseListeners((GenericFutureListener)this.listeners, listener);
                }
                return this;
            }
        }
        DefaultPromise.notifyListener(this.executor(), this, listener);
        return this;
    }

    @Override
    public Promise<V> addListeners(GenericFutureListener<? extends Future<V>> ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (GenericFutureListener<? extends Future<V>> l : listeners) {
            if (l == null) break;
            this.addListener((GenericFutureListener)l);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends Future<V>> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            return this;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (!this.isDone()) {
                if (this.listeners instanceof DefaultPromiseListeners) {
                    ((DefaultPromiseListeners)this.listeners).remove(listener);
                } else if (this.listeners == listener) {
                    this.listeners = null;
                }
            }
        }
        return this;
    }

    @Override
    public Promise<V> removeListeners(GenericFutureListener<? extends Future<V>> ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (GenericFutureListener<? extends Future<V>> l : listeners) {
            if (l == null) break;
            this.removeListener((GenericFutureListener)l);
        }
        return this;
    }

    @Override
    public Promise<V> sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    private void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause == null) {
            return;
        }
        PlatformDependent.throwException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.checkDeadLock();
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        boolean interrupted = false;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.checkDeadLock();
                this.incWaiters();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkDeadLock() {
        EventExecutor e = this.executor();
        if (e != null && e.inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    @Override
    public Promise<V> setSuccess(V result) {
        if (this.setSuccess0(result)) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException("complete already");
    }

    @Override
    public boolean trySuccess(V result) {
        if (this.setSuccess0(result)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    @Override
    public Promise<V> setFailure(Throwable cause) {
        if (this.setFailure0(cause)) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException("complete already", cause);
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.setFailure0(cause)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFailure0(Throwable cause) {
        if (this.isDone()) {
            return false;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.isDone()) {
                return false;
            }
            this.result = new CauseHolder(cause);
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSuccess0(V result) {
        if (this.isDone()) {
            return false;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.isDone()) {
                return false;
            }
            this.result = result == null ? SUCCESS : result;
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    @Override
    public V getNow() {
        Object result = this.result;
        if (result instanceof CauseHolder || result == SUCCESS) {
            return null;
        }
        return (V)result;
    }

    private boolean hasWaiters() {
        return (this.state & 0xFFFFFF0000000000L) != 0L;
    }

    private void incWaiters() {
        long newState = this.state + 0x10000000000L;
        if ((newState & 0xFFFFFF0000000000L) == 0L) {
            throw new IllegalStateException("too many waiters");
        }
        this.state = newState;
    }

    private void decWaiters() {
        this.state -= 0x10000000000L;
    }

    private void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            if (this.listeners instanceof DefaultPromiseListeners) {
                DefaultPromise.notifyListeners0(this, (DefaultPromiseListeners)this.listeners);
            } else {
                DefaultPromise.notifyListener0(this, (GenericFutureListener)this.listeners);
            }
            this.listeners = null;
        } else {
            final Object listeners = this.listeners;
            this.listeners = null;
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (listeners instanceof DefaultPromiseListeners) {
                            DefaultPromise.notifyListeners0(DefaultPromise.this, (DefaultPromiseListeners)listeners);
                        } else {
                            DefaultPromise.notifyListener0(DefaultPromise.this, (GenericFutureListener)listeners);
                        }
                    }
                });
            }
            catch (Throwable t) {
                logger.error("Failed to notify listener(s). Event loop terminated?", t);
            }
        }
    }

    private static void notifyListeners0(Future<?> future, DefaultPromiseListeners listeners) {
        GenericFutureListener<? extends Future<?>>[] a = listeners.listeners();
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            DefaultPromise.notifyListener0(future, a[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyListener(final EventExecutor eventExecutor, final Future<?> future, final GenericFutureListener<? extends Future<?>> l) {
        Integer stackDepth;
        if (eventExecutor.inEventLoop() && (stackDepth = LISTENER_STACK_DEPTH.get()) < 8) {
            LISTENER_STACK_DEPTH.set(stackDepth + 1);
            try {
                DefaultPromise.notifyListener0(future, l);
            }
            finally {
                LISTENER_STACK_DEPTH.set(stackDepth);
            }
            return;
        }
        try {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultPromise.notifyListener(eventExecutor, future, l);
                }
            });
        }
        catch (Throwable t) {
            logger.error("Failed to notify a listener. Event loop terminated?", t);
        }
    }

    private static void notifyListener0(Future future, GenericFutureListener l) {
        block2: {
            try {
                l.operationComplete(future);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + GenericFutureListener.class.getSimpleName() + '.', t);
            }
        }
    }

    private static final class CauseHolder {
        final Throwable cause;

        private CauseHolder(Throwable cause) {
            this.cause = cause;
        }
    }
}

