/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.bytes;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundMessageHandlerAdapter;

@ChannelHandler.Sharable
public class ByteArrayEncoder
extends ChannelOutboundMessageHandlerAdapter<byte[]> {
    public void flush(ChannelHandlerContext ctx, byte[] msg) throws Exception {
        if (msg.length == 0) {
            return;
        }
        switch (ctx.nextOutboundBufferType()) {
            case BYTE: {
                ctx.nextOutboundByteBuffer().writeBytes(msg);
                break;
            }
            case MESSAGE: {
                ctx.nextOutboundMessageBuffer().add((Object)Unpooled.wrappedBuffer((byte[])msg));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

