/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelOperationHandler;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelStateHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.spdy.SpdyDataOrControlFrame;
import io.netty.handler.codec.spdy.SpdyFrameDecoder;
import io.netty.handler.codec.spdy.SpdyFrameEncoder;

public final class SpdyFrameCodec
extends CombinedChannelDuplexHandler
implements ChannelInboundByteHandler,
ChannelOutboundMessageHandler<SpdyDataOrControlFrame> {
    public SpdyFrameCodec(int version) {
        this(version, 8192, 16384, 6, 15, 8);
    }

    public SpdyFrameCodec(int version, int maxChunkSize, int maxHeaderSize, int compressionLevel, int windowBits, int memLevel) {
        super((ChannelStateHandler)new SpdyFrameDecoder(version, maxChunkSize, maxHeaderSize), (ChannelOperationHandler)new SpdyFrameEncoder(version, compressionLevel, windowBits, memLevel));
    }

    private SpdyFrameDecoder decoder() {
        return (SpdyFrameDecoder)this.stateHandler();
    }

    private SpdyFrameEncoder encoder() {
        return (SpdyFrameEncoder)this.operationHandler();
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return this.decoder().newInboundBuffer(ctx);
    }

    public void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        this.decoder().discardInboundReadBytes(ctx);
    }

    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        this.decoder().freeInboundBuffer(ctx);
    }

    public MessageBuf<SpdyDataOrControlFrame> newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return this.encoder().newOutboundBuffer(ctx);
    }

    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        this.encoder().freeOutboundBuffer(ctx);
    }
}

