/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.DefaultMcpSession;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncServer.class);
    private final DefaultMcpSession mcpSession;
    private final ServerMcpTransport transport;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private McpSchema.ClientCapabilities clientCapabilities;
    private McpSchema.Implementation clientInfo;
    private final CopyOnWriteArrayList<McpServerFeatures.AsyncToolRegistration> tools = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, McpServerFeatures.AsyncResourceRegistration> resources = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpServerFeatures.AsyncPromptRegistration> prompts = new ConcurrentHashMap();
    private McpSchema.LoggingLevel minLoggingLevel = McpSchema.LoggingLevel.DEBUG;
    private List<String> protocolVersions = List.of("2024-11-05");
    private static final TypeReference<McpSchema.ListRootsResult> LIST_ROOTS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListRootsResult>(){};
    private static final TypeReference<McpSchema.CreateMessageResult> CREATE_MESSAGE_RESULT_TYPE_REF = new TypeReference<McpSchema.CreateMessageResult>(){};

    McpAsyncServer(ServerMcpTransport mcpTransport, McpServerFeatures.Async features) {
        this.serverInfo = features.serverInfo();
        this.serverCapabilities = features.serverCapabilities();
        this.tools.addAll(features.tools());
        this.resources.putAll(features.resources());
        this.resourceTemplates.addAll(features.resourceTemplates());
        this.prompts.putAll(features.prompts());
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("initialize", this.asyncInitializeRequestHandler());
        requestHandlers.put("ping", params -> Mono.just((Object)""));
        if (this.serverCapabilities.tools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (!Utils.isEmpty(this.resources)) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
        }
        if (!Utils.isEmpty(this.resourceTemplates)) {
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (!Utils.isEmpty(this.prompts)) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        if (this.serverCapabilities.logging() != null) {
            requestHandlers.put("logging/setLevel", this.setLoggerRequestHandler());
        }
        HashMap<String, DefaultMcpSession.NotificationHandler> notificationHandlers = new HashMap<String, DefaultMcpSession.NotificationHandler>();
        notificationHandlers.put("notifications/initialized", params -> Mono.empty());
        List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers = features.rootsChangeConsumers();
        if (Utils.isEmpty(rootsChangeConsumers)) {
            rootsChangeConsumers = List.of(roots -> Mono.fromRunnable(() -> logger.warn("Roots list changed notification, but no consumers provided. Roots list changed: {}", roots)));
        }
        notificationHandlers.put("notifications/roots/list_changed", this.asyncRootsListChangedNotificationHandler(rootsChangeConsumers));
        this.transport = mcpTransport;
        this.mcpSession = new DefaultMcpSession(Duration.ofSeconds(10L), mcpTransport, requestHandlers, notificationHandlers);
    }

    private DefaultMcpSession.RequestHandler<McpSchema.InitializeResult> asyncInitializeRequestHandler() {
        return params -> {
            McpSchema.InitializeRequest initializeRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.InitializeRequest>(){});
            this.clientCapabilities = initializeRequest.capabilities();
            this.clientInfo = initializeRequest.clientInfo();
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.protocolVersion(), initializeRequest.capabilities(), initializeRequest.clientInfo()});
            String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
            if (this.protocolVersions.contains(initializeRequest.protocolVersion())) {
                serverProtocolVersion = initializeRequest.protocolVersion();
            } else {
                logger.warn("Client requested unsupported protocol version: {}, so the server will sugggest the {} version instead", (Object)initializeRequest.protocolVersion(), (Object)serverProtocolVersion);
            }
            return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, null));
        };
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    public McpSchema.Implementation getServerInfo() {
        return this.serverInfo;
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    public McpSchema.Implementation getClientInfo() {
        return this.clientInfo;
    }

    public Mono<Void> closeGracefully() {
        return this.mcpSession.closeGracefully();
    }

    public void close() {
        this.mcpSession.close();
    }

    public Mono<McpSchema.ListRootsResult> listRoots() {
        return this.listRoots(null);
    }

    public Mono<McpSchema.ListRootsResult> listRoots(String cursor) {
        return this.mcpSession.sendRequest("roots/list", new McpSchema.PaginatedRequest(cursor), LIST_ROOTS_RESULT_TYPE_REF);
    }

    private DefaultMcpSession.NotificationHandler asyncRootsListChangedNotificationHandler(List<Function<List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
        return params -> this.listRoots().flatMap(listRootsResult -> Flux.fromIterable((Iterable)rootsChangeConsumers).flatMap(consumer -> (Publisher)consumer.apply(listRootsResult.roots())).onErrorResume(error -> {
            logger.error("Error handling roots list change notification", error);
            return Mono.empty();
        }).then());
    }

    public Mono<Void> addTool(McpServerFeatures.AsyncToolRegistration toolRegistration) {
        if (toolRegistration == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool registration must not be null"));
        }
        if (toolRegistration.tool() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
        }
        if (toolRegistration.call() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        return Mono.defer(() -> {
            if (this.tools.stream().anyMatch(th -> th.tool().name().equals(toolRegistration.tool().name()))) {
                return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolRegistration.tool().name() + "' already exists")));
            }
            this.tools.add(toolRegistration);
            logger.debug("Added tool handler: {}", (Object)toolRegistration.tool().name());
            if (this.serverCapabilities.tools().listChanged().booleanValue()) {
                return this.notifyToolsListChanged();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> removeTool(String toolName) {
        if (toolName == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        return Mono.defer(() -> {
            boolean removed = this.tools.removeIf(toolRegistration -> toolRegistration.tool().name().equals(toolName));
            if (removed) {
                logger.debug("Removed tool handler: {}", (Object)toolName);
                if (this.serverCapabilities.tools().listChanged().booleanValue()) {
                    return this.notifyToolsListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
        });
    }

    public Mono<Void> notifyToolsListChanged() {
        return this.mcpSession.sendNotification("notifications/tools/list_changed", null);
    }

    private DefaultMcpSession.RequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
        return params -> {
            List<McpSchema.Tool> tools = this.tools.stream().map(McpServerFeatures.AsyncToolRegistration::tool).toList();
            return Mono.just((Object)new McpSchema.ListToolsResult(tools, null));
        };
    }

    private DefaultMcpSession.RequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
        return params -> {
            McpSchema.CallToolRequest callToolRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.CallToolRequest>(){});
            Optional<McpServerFeatures.AsyncToolRegistration> toolRegistration = this.tools.stream().filter(tr -> callToolRequest.name().equals(tr.tool().name())).findAny();
            if (toolRegistration.isEmpty()) {
                return Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name())));
            }
            return toolRegistration.map(tool -> tool.call().apply(callToolRequest.arguments())).orElse(Mono.error((Throwable)new McpError((Object)("Tool not found: " + callToolRequest.name()))));
        };
    }

    public Mono<Void> addResource(McpServerFeatures.AsyncResourceRegistration resourceHandler) {
        if (resourceHandler == null || resourceHandler.resource() == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            if (this.resources.putIfAbsent(resourceHandler.resource().uri(), resourceHandler) != null) {
                return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceHandler.resource().uri() + "' already exists")));
            }
            logger.debug("Added resource handler: {}", (Object)resourceHandler.resource().uri());
            if (this.serverCapabilities.resources().listChanged().booleanValue()) {
                return this.notifyResourcesListChanged();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncResourceRegistration removed = this.resources.remove(resourceUri);
            if (removed != null) {
                logger.debug("Removed resource handler: {}", (Object)resourceUri);
                if (this.serverCapabilities.resources().listChanged().booleanValue()) {
                    return this.notifyResourcesListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
        });
    }

    public Mono<Void> notifyResourcesListChanged() {
        return this.mcpSession.sendNotification("notifications/resources/list_changed", null);
    }

    private DefaultMcpSession.RequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
        return params -> {
            List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpServerFeatures.AsyncResourceRegistration::resource).toList();
            return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private DefaultMcpSession.RequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
        return params -> Mono.just((Object)new McpSchema.ListResourceTemplatesResult(this.resourceTemplates, null));
    }

    private DefaultMcpSession.RequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
        return params -> {
            McpSchema.ReadResourceRequest resourceRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.ReadResourceRequest>(){});
            String resourceUri = resourceRequest.uri();
            McpServerFeatures.AsyncResourceRegistration registration = this.resources.get(resourceUri);
            if (registration != null) {
                return registration.readHandler().apply(resourceRequest);
            }
            return Mono.error((Throwable)new McpError((Object)("Resource not found: " + resourceUri)));
        };
    }

    public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptRegistration promptRegistration) {
        if (promptRegistration == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt registration must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncPromptRegistration registration = this.prompts.putIfAbsent(promptRegistration.prompt().name(), promptRegistration);
            if (registration != null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptRegistration.prompt().name() + "' already exists")));
            }
            logger.debug("Added prompt handler: {}", (Object)promptRegistration.prompt().name());
            if (this.serverCapabilities.prompts().listChanged().booleanValue()) {
                return this.notifyPromptsListChanged();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> removePrompt(String promptName) {
        if (promptName == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncPromptRegistration removed = this.prompts.remove(promptName);
            if (removed != null) {
                logger.debug("Removed prompt handler: {}", (Object)promptName);
                if (this.serverCapabilities.prompts().listChanged().booleanValue()) {
                    return this.notifyPromptsListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
        });
    }

    public Mono<Void> notifyPromptsListChanged() {
        return this.mcpSession.sendNotification("notifications/prompts/list_changed", null);
    }

    private DefaultMcpSession.RequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
        return params -> {
            List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpServerFeatures.AsyncPromptRegistration::prompt).toList();
            return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private DefaultMcpSession.RequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
        return params -> {
            McpSchema.GetPromptRequest promptRequest = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.GetPromptRequest>(){});
            McpServerFeatures.AsyncPromptRegistration registration = this.prompts.get(promptRequest.name());
            if (registration == null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptRequest.name())));
            }
            return registration.promptHandler().apply(promptRequest);
        };
    }

    public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        if (loggingMessageNotification == null) {
            return Mono.error((Throwable)new McpError((Object)"Logging message must not be null"));
        }
        Map<String, Object> params = this.transport.unmarshalFrom(loggingMessageNotification, new TypeReference<Map<String, Object>>(){});
        if (loggingMessageNotification.level().level() < this.minLoggingLevel.level()) {
            return Mono.empty();
        }
        return this.mcpSession.sendNotification("notifications/message", params);
    }

    private DefaultMcpSession.RequestHandler<Void> setLoggerRequestHandler() {
        return params -> {
            this.minLoggingLevel = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.LoggingLevel>(){});
            return Mono.empty();
        };
    }

    public Mono<McpSchema.CreateMessageResult> createMessage(McpSchema.CreateMessageRequest createMessageRequest) {
        if (this.clientCapabilities == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be initialized. Call the initialize method first!"));
        }
        if (this.clientCapabilities.sampling() == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be configured with sampling capabilities"));
        }
        return this.mcpSession.sendRequest("sampling/createMessage", createMessageRequest, CREATE_MESSAGE_RESULT_TYPE_REF);
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }
}

