/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.propagation;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

public interface Propagator {
    public static final Propagator NOOP = new Propagator(){

        @Override
        public List<String> fields() {
            return Collections.emptyList();
        }

        @Override
        public <C> void inject(TraceContext context, @Nullable C carrier, Setter<C> setter) {
        }

        @Override
        public <C> Span.Builder extract(@Nullable C carrier, Getter<C> getter) {
            return Span.Builder.NOOP;
        }
    };

    public List<String> fields();

    public <C> void inject(TraceContext var1, @Nullable C var2, Setter<C> var3);

    public <C> Span.Builder extract(@Nullable C var1, Getter<C> var2);

    public static interface Getter<C> {
        public static final Getter NOOP = (carrier, key) -> null;

        public @Nullable String get(C var1, String var2);

        default public Iterable<String> getAll(C carrier, String key) {
            String firstValue = this.get(carrier, key);
            if (firstValue == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(firstValue);
        }
    }

    public static interface Setter<C> {
        public static final Setter NOOP = (carrier, key, value) -> {};

        public void set(@Nullable C var1, String var2, String var3);
    }
}

