/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.annotation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.annotation.AnnotationHandler;
import io.micrometer.common.annotation.NoOpValueResolver;
import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.common.annotation.ValueResolver;
import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.SpanCustomizer;
import io.micrometer.tracing.annotation.SpanTag;
import java.util.function.Function;

public class SpanTagAnnotationHandler
extends AnnotationHandler<SpanCustomizer> {
    public SpanTagAnnotationHandler(Function<Class<? extends ValueResolver>, ? extends ValueResolver> resolverProvider, Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> expressionResolverProvider) {
        super((keyValue, spanCustomizer) -> spanCustomizer.tag(keyValue.getKey(), keyValue.getValue()), resolverProvider, expressionResolverProvider, SpanTag.class, (annotation, o) -> {
            if (!(annotation instanceof SpanTag)) {
                return null;
            }
            SpanTag spanTag = (SpanTag)annotation;
            return KeyValue.of((String)SpanTagAnnotationHandler.resolveTagKey(spanTag), (String)SpanTagAnnotationHandler.resolveTagValue(spanTag, o, resolverProvider, expressionResolverProvider));
        });
    }

    private static String resolveTagKey(SpanTag annotation) {
        return StringUtils.isNotBlank((String)annotation.value()) ? annotation.value() : annotation.key();
    }

    static String resolveTagValue(SpanTag annotation, Object argument, Function<Class<? extends ValueResolver>, ? extends ValueResolver> resolverProvider, Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> expressionResolverProvider) {
        String value = null;
        if (annotation.resolver() != NoOpValueResolver.class) {
            ValueResolver ValueResolver2 = resolverProvider.apply(annotation.resolver());
            value = ValueResolver2.resolve(argument);
        } else if (StringUtils.isNotBlank((String)annotation.expression())) {
            value = expressionResolverProvider.apply(ValueExpressionResolver.class).resolve(annotation.expression(), argument);
        } else if (argument != null) {
            value = argument.toString();
        }
        return value == null ? "" : value;
    }
}

