/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.mail;

import io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import io.micrometer.observation.transport.SenderContext;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import org.jspecify.annotations.Nullable;

public class MailSendObservationContext
extends SenderContext<Message> {
    private static final WarnThenDebugLogger logger = new WarnThenDebugLogger(MailSendObservationContext.class);
    private final @Nullable String protocol;
    private final @Nullable String host;
    private final int port;

    public MailSendObservationContext(Message msg, @Nullable String protocol, @Nullable String host, int port) {
        super((message, key, value) -> {
            if (message != null) {
                try {
                    message.setHeader(key, value);
                }
                catch (MessagingException exc) {
                    logger.log("Failed to set message header.", (Throwable)exc);
                }
            }
        });
        this.setCarrier(msg);
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public @Nullable String getProtocol() {
        return this.protocol;
    }

    public @Nullable String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

