/*
 * Decompiled with CFR 0.152.
 */
package io.michaelrocks.libphonenumber.android;

import io.michaelrocks.libphonenumber.android.AlternateFormatsCountryCodeSet;
import io.michaelrocks.libphonenumber.android.MetadataLoader;
import io.michaelrocks.libphonenumber.android.Phonemetadata;
import io.michaelrocks.libphonenumber.android.ShortNumbersRegionCodeSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MetadataManager {
    static final String MULTI_FILE_PHONE_NUMBER_METADATA_FILE_PREFIX = "/io/michaelrocks/libphonenumber/android/data/PhoneNumberMetadataProto";
    static final String ALTERNATE_FORMATS_FILE_PREFIX = "/io/michaelrocks/libphonenumber/android/data/PhoneNumberAlternateFormatsProto";
    static final String SHORT_NUMBER_METADATA_FILE_PREFIX = "/io/michaelrocks/libphonenumber/android/data/ShortNumberMetadataProto";
    private static final Logger logger = Logger.getLogger(MetadataManager.class.getName());
    private final MetadataLoader metadataLoader;
    private final ConcurrentHashMap<Integer, Phonemetadata.PhoneMetadata> alternateFormatsMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Phonemetadata.PhoneMetadata> shortNumberMetadataMap = new ConcurrentHashMap();
    private final Set<Integer> alternateFormatsCountryCodes = AlternateFormatsCountryCodeSet.getCountryCodeSet();
    private final Set<String> shortNumberMetadataRegionCodes = ShortNumbersRegionCodeSet.getRegionCodeSet();

    MetadataManager(MetadataLoader metadataLoader) {
        this.metadataLoader = metadataLoader;
    }

    Phonemetadata.PhoneMetadata getAlternateFormatsForCountry(int countryCallingCode, String filePrefix) {
        if (!this.alternateFormatsCountryCodes.contains(countryCallingCode)) {
            return null;
        }
        return this.getMetadataFromMultiFilePrefix(countryCallingCode, this.alternateFormatsMap, filePrefix);
    }

    Phonemetadata.PhoneMetadata getShortNumberMetadataForRegion(String regionCode, String filePrefix) {
        if (!this.shortNumberMetadataRegionCodes.contains(regionCode)) {
            return null;
        }
        return this.getMetadataFromMultiFilePrefix(regionCode, this.shortNumberMetadataMap, filePrefix);
    }

    Set<String> getSupportedShortNumberRegions() {
        return Collections.unmodifiableSet(this.shortNumberMetadataRegionCodes);
    }

    <T> Phonemetadata.PhoneMetadata getMetadataFromMultiFilePrefix(T key, ConcurrentHashMap<T, Phonemetadata.PhoneMetadata> map, String filePrefix) {
        Phonemetadata.PhoneMetadata oldValue;
        Phonemetadata.PhoneMetadata metadata = map.get(key);
        if (metadata != null) {
            return metadata;
        }
        String fileName = filePrefix + "_" + key;
        List<Phonemetadata.PhoneMetadata> metadataList = MetadataManager.getMetadataFromSingleFileName(fileName, this.metadataLoader);
        if (metadataList.size() > 1) {
            logger.log(Level.WARNING, "more than one metadata in file " + fileName);
        }
        return (oldValue = map.putIfAbsent(key, metadata = metadataList.get(0))) != null ? oldValue : metadata;
    }

    private static List<Phonemetadata.PhoneMetadata> getMetadataFromSingleFileName(String fileName, MetadataLoader metadataLoader) {
        InputStream source = metadataLoader.loadMetadata(fileName);
        if (source == null) {
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        Phonemetadata.PhoneMetadataCollection metadataCollection = MetadataManager.loadMetadataAndCloseInput(source);
        List<Phonemetadata.PhoneMetadata> metadataList = metadataCollection.getMetadataList();
        if (metadataList.size() == 0) {
            throw new IllegalStateException("empty metadata: " + fileName);
        }
        return metadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(InputStream source) {
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(source);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load/parse metadata", e);
            }
            Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
            try {
                metadataCollection.readExternal(ois);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load/parse metadata", e);
            }
            Phonemetadata.PhoneMetadataCollection phoneMetadataCollection = metadataCollection;
            return phoneMetadataCollection;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                } else {
                    source.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing input stream (ignored)", e);
            }
        }
    }
}

