/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\r\u001a\u00020\u0002H\u0096\u0080\u0004\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lio/ktor/http/content/TextContent;", "Lio/ktor/http/content/OutgoingContent$ByteArrayContent;", "", "text", "Lio/ktor/http/ContentType;", "contentType", "Lio/ktor/http/HttpStatusCode;", "status", "<init>", "(Ljava/lang/String;Lio/ktor/http/ContentType;Lio/ktor/http/HttpStatusCode;)V", "", "bytes", "()[B", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getText", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "[B", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "ktor-http"})
public final class TextContent
extends OutgoingContent.ByteArrayContent {
    @NotNull
    private final String text;
    @NotNull
    private final ContentType contentType;
    @Nullable
    private final HttpStatusCode status;
    @NotNull
    private final byte[] bytes;

    public TextContent(@NotNull String text, @NotNull ContentType contentType, @Nullable HttpStatusCode status) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.text = text;
        this.contentType = contentType;
        this.status = status;
        Charset charset = ContentTypesKt.charset(this.getContentType());
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        this.bytes = io.ktor.utils.io.core.StringsKt.toByteArray((String)this.text, (Charset)charset);
    }

    public /* synthetic */ TextContent(String string, ContentType contentType, HttpStatusCode httpStatusCode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            httpStatusCode = null;
        }
        this(string, contentType, httpStatusCode);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public Long getContentLength() {
        return this.bytes.length;
    }

    @Override
    @NotNull
    public byte[] bytes() {
        return this.bytes;
    }

    @NotNull
    public String toString() {
        return "TextContent[" + this.getContentType() + "] \"" + StringsKt.take((String)this.text, (int)30) + '\"';
    }
}

