/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001d\u0010\u0004\u001a\u00020\u0000*\u00020\u00002\n\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0006\u001a\u00020\u0000*\u00020\u00002\n\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0019\u0010\u0003\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00020\u0007\u00a2\u0006\u0004\b\u0003\u0010\b\u001a\u0011\u0010\n\u001a\u00020\t*\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\"\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/ktor/http/ContentType;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "withCharset", "(Lio/ktor/http/ContentType;Ljava/nio/charset/Charset;)Lio/ktor/http/ContentType;", "withCharsetIfNeeded", "Lio/ktor/http/HeaderValueWithParameters;", "(Lio/ktor/http/HeaderValueWithParameters;)Ljava/nio/charset/Charset;", "", "isTextType", "(Lio/ktor/http/ContentType;)Z", "", "", "textSubTypes", "Ljava/util/Set;", "ktor-http"})
public final class ContentTypesKt {
    @NotNull
    private static final Set<String> textSubTypes;

    @NotNull
    public static final ContentType withCharset(@NotNull ContentType $this$withCharset, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$withCharset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return $this$withCharset.withParameter("charset", CharsetJVMKt.getName((Charset)charset));
    }

    @NotNull
    public static final ContentType withCharsetIfNeeded(@NotNull ContentType $this$withCharsetIfNeeded, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$withCharsetIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String string = $this$withCharsetIfNeeded.getContentType().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return !Intrinsics.areEqual((Object)string, (Object)"text") ? $this$withCharsetIfNeeded : $this$withCharsetIfNeeded.withParameter("charset", CharsetJVMKt.getName((Charset)charset));
    }

    @Nullable
    public static final Charset charset(@NotNull HeaderValueWithParameters $this$charset) {
        Charset charset;
        Intrinsics.checkNotNullParameter((Object)$this$charset, (String)"<this>");
        String string = $this$charset.parameter("charset");
        if (string != null) {
            Charset charset2;
            String it = string;
            boolean bl = false;
            try {
                charset2 = CharsetJVMKt.forName((Charsets)Charsets.INSTANCE, (String)it);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                charset2 = null;
            }
            charset = charset2;
        } else {
            charset = null;
        }
        return charset;
    }

    public static final boolean isTextType(@NotNull ContentType $this$isTextType) {
        Intrinsics.checkNotNullParameter((Object)$this$isTextType, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$isTextType.getContentType(), (Object)"text")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)$this$isTextType.getContentType(), (Object)"application")) {
            String string = $this$isTextType.getContentSubtype().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (textSubTypes.contains(string)) {
                return true;
            }
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"json", "ld+json", "xml", "xhtml+xml", "rss+xml", "atom+xml", "x-www-form-urlencoded", "svg+xml"};
        textSubTypes = SetsKt.setOf((Object[])objectArray);
    }
}

