/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.instance;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.error.InstanceCreationException;
import org.koin.core.instance.ResolutionContext;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.parameter.ParametersHolderKt;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00060\u0002j\u0002`\u0003:\u0001\u0016B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH&J\u0014\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H&J\b\u0010\u0015\u001a\u00020\u0012H&R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/koin/core/instance/InstanceFactory;", "T", "", "Lorg/koin/mp/Lockable;", "beanDefinition", "Lorg/koin/core/definition/BeanDefinition;", "<init>", "(Lorg/koin/core/definition/BeanDefinition;)V", "getBeanDefinition", "()Lorg/koin/core/definition/BeanDefinition;", "get", "context", "Lorg/koin/core/instance/ResolutionContext;", "(Lorg/koin/core/instance/ResolutionContext;)Ljava/lang/Object;", "create", "isCreated", "", "drop", "", "scope", "Lorg/koin/core/scope/Scope;", "dropAll", "Companion", "koin-core"})
public abstract class InstanceFactory<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BeanDefinition<T> beanDefinition;
    @NotNull
    public static final String ERROR_SEPARATOR = "\n\t";

    public InstanceFactory(@NotNull BeanDefinition<T> beanDefinition) {
        Intrinsics.checkNotNullParameter(beanDefinition, (String)"beanDefinition");
        this.beanDefinition = beanDefinition;
    }

    @NotNull
    public final BeanDefinition<T> getBeanDefinition() {
        return this.beanDefinition;
    }

    public abstract T get(@NotNull ResolutionContext var1);

    public T create(@NotNull ResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getLogger().debug("| (+) '" + this.beanDefinition + '\'');
        try {
            ParametersHolder parametersHolder = context.getParameters();
            if (parametersHolder == null) {
                parametersHolder = ParametersHolderKt.emptyParametersHolder();
            }
            ParametersHolder parameters = parametersHolder;
            return (T)this.beanDefinition.getDefinition().invoke((Object)context.getScope(), (Object)parameters);
        }
        catch (Exception e) {
            String stack = KoinPlatformTools.INSTANCE.getStackTrace(e);
            context.getLogger().error("* Instance creation error : could not create instance for '" + this.beanDefinition + "': " + stack);
            throw new InstanceCreationException("Could not create instance for '" + this.beanDefinition + '\'', e);
        }
    }

    public abstract boolean isCreated(@Nullable ResolutionContext var1);

    public static /* synthetic */ boolean isCreated$default(InstanceFactory instanceFactory, ResolutionContext resolutionContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isCreated");
        }
        if ((n & 1) != 0) {
            resolutionContext = null;
        }
        return instanceFactory.isCreated(resolutionContext);
    }

    public abstract void drop(@Nullable Scope var1);

    public static /* synthetic */ void drop$default(InstanceFactory instanceFactory, Scope scope, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drop");
        }
        if ((n & 1) != 0) {
            scope = null;
        }
        instanceFactory.drop(scope);
    }

    public abstract void dropAll();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/koin/core/instance/InstanceFactory$Companion;", "", "<init>", "()V", "ERROR_SEPARATOR", "", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

