/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.core.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;

public final class ResourceLoader {
    private static final String ERR_RESOURCE_MISSING = "Resource '%s' is missing.";
    private final ClassLoader classLoader;

    public ResourceLoader(Class<?> clazz) {
        this(clazz.getClassLoader());
    }

    public ResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String readAsText(String resourcePath, Charset charset) {
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = this.resourceReader(resourcePath, charset);){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        catch (IOException readResourceException) {
            throw new RuntimeException(readResourceException);
        }
        return textBuilder.toString();
    }

    public BufferedReader resourceReader(String resourcePath, Charset charset) {
        InputStream resourceStream = this.resourceStream(resourcePath);
        InputStreamReader inputStreamReader = new InputStreamReader(resourceStream, charset);
        return new BufferedReader(inputStreamReader);
    }

    public byte[] readAsByteArray(String resourcePath) {
        byte[] byArray;
        block8: {
            InputStream is = this.resourceStream(resourcePath);
            try {
                byte[] data = new byte[is.available()];
                is.read(data);
                byArray = data;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException readResourceException) {
                    throw new RuntimeException(readResourceException);
                }
            }
            is.close();
        }
        return byArray;
    }

    public InputStream resourceStream(String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        InputStream resourceAsStream = this.classLoader.getResourceAsStream(resourcePath);
        return Objects.requireNonNull(resourceAsStream, String.format(ERR_RESOURCE_MISSING, resourcePath));
    }
}

