/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.core;

import io.hosuaby.inject.resources.core.ResourceAsByteArray;
import io.hosuaby.inject.resources.core.ResourceAsInputStream;
import io.hosuaby.inject.resources.core.ResourceAsLines;
import io.hosuaby.inject.resources.core.ResourceAsReader;
import io.hosuaby.inject.resources.core.ResourceAsText;
import io.hosuaby.inject.resources.core.helpers.ResourceLoader;
import io.hosuaby.inject.resources.core.helpers.StringUtils;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Resource {
    protected final ResourceLoader resourceLoader;
    protected final String resourcePath;

    Resource(ResourceLoader resourceLoader, String resourcePath) {
        this.resourceLoader = resourceLoader;
        this.resourcePath = resourcePath;
    }

    public ResourceAsInputStream asInputStream() {
        return new ResourceAsInputStream(this);
    }

    public ResourceAsByteArray asByteArray() {
        return new ResourceAsByteArray(this);
    }

    public byte[] bytes() {
        return new ResourceAsByteArray(this).bytes();
    }

    public ResourceAsReader asReader() {
        return new ResourceAsReader(this);
    }

    public ResourceAsReader asReader(Charset charset) {
        return new ResourceAsReader(this, charset);
    }

    public ResourceAsLines asLines() {
        return new ResourceAsReader(this).asLines();
    }

    public ResourceAsLines asLines(Charset charset) {
        return new ResourceAsReader(this, charset).asLines();
    }

    public ResourceAsText asText() {
        return new ResourceAsText(this);
    }

    public ResourceAsText asText(Charset charset) {
        return new ResourceAsText(this, charset);
    }

    public String text() {
        return new ResourceAsText(this).text();
    }

    public String text(Charset charset) {
        return new ResourceAsText(this, charset).text();
    }

    public static String buildPath(String firstPathToken, String ... otherTokens) {
        return Stream.concat(Stream.of(firstPathToken), Stream.of(otherTokens)).map(token -> token.split("/")).flatMap(Stream::of).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
    }

    public static final class ResourceOnClassloader {
        private final ResourceLoader resourceLoader;

        ResourceOnClassloader(ClassLoader classLoader) {
            this.resourceLoader = new ResourceLoader(classLoader);
        }

        public Resource withPath(String firstPathToken, String ... otherTokens) {
            String resourcePath = Resource.buildPath(firstPathToken, otherTokens);
            return new Resource(this.resourceLoader, resourcePath);
        }
    }
}

