/*
 * Decompiled with CFR 0.152.
 */
package io.hosuaby.inject.resources.core;

import io.hosuaby.inject.resources.core.function.ThrowingConsumer;
import io.hosuaby.inject.resources.core.function.ThrowingFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Parsable<I> {
    public I get();

    default public <O> O parse(Function<I, O> parsingFunction) {
        return parsingFunction.apply(this.get());
    }

    default public <O> O parseChecked(ThrowingFunction<I, O> parsingFunction) {
        I content = this.get();
        try {
            O o = parsingFunction.apply(content);
            return o;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            if (content instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)content).close();
                }
                catch (Exception closeException) {
                    throw new RuntimeException(closeException);
                }
            }
        }
    }

    default public void then(Consumer<I> contentConsumer) {
        contentConsumer.accept(this.get());
    }

    default public void thenChecked(ThrowingConsumer<I> contentConsumer) {
        I content = this.get();
        try {
            contentConsumer.accept(this.get());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            if (content instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)content).close();
                }
                catch (Exception closeException) {
                    throw new RuntimeException(closeException);
                }
            }
        }
    }
}

